/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.Nullable;
import android.content.ClipData;
import android.content.ClipDescription;
import android.view.DragEvent;
import android.view.SurfaceControl;
import com.android.internal.view.IDragAndDropPermissions;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class DragEventBuilder {
    private int action;
    private float x;
    private float y;
    @Nullable
    private Object localState;
    @Nullable
    private ClipDescription clipDescription;
    @Nullable
    private ClipData clipData;
    private boolean result;

    private DragEventBuilder() {
    }

    public static DragEventBuilder newBuilder() {
        return new DragEventBuilder();
    }

    public DragEventBuilder setAction(int action) {
        this.action = action;
        return this;
    }

    public DragEventBuilder setX(float x) {
        this.x = x;
        return this;
    }

    public DragEventBuilder setY(float y) {
        this.y = y;
        return this;
    }

    public DragEventBuilder setLocalState(@Nullable Object localState) {
        this.localState = localState;
        return this;
    }

    public DragEventBuilder setClipDescription(@Nullable ClipDescription clipDescription) {
        this.clipDescription = clipDescription;
        return this;
    }

    public DragEventBuilder setClipData(@Nullable ClipData clipData) {
        this.clipData = clipData;
        return this;
    }

    public DragEventBuilder setResult(boolean result) {
        this.result = result;
        return this;
    }

    public DragEvent build() {
        int api = RuntimeEnvironment.getApiLevel();
        if (api <= 23) {
            return (DragEvent)ReflectionHelpers.callStaticMethod(DragEvent.class, (String)"obtain", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.action), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.x)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.y)), ReflectionHelpers.ClassParameter.from(Object.class, (Object)this.localState), ReflectionHelpers.ClassParameter.from(ClipDescription.class, (Object)this.clipDescription), ReflectionHelpers.ClassParameter.from(ClipData.class, (Object)this.clipData), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.result)});
        }
        if (api <= 30) {
            return (DragEvent)ReflectionHelpers.callStaticMethod(DragEvent.class, (String)"obtain", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.action), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.x)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.y)), ReflectionHelpers.ClassParameter.from(Object.class, (Object)this.localState), ReflectionHelpers.ClassParameter.from(ClipDescription.class, (Object)this.clipDescription), ReflectionHelpers.ClassParameter.from(ClipData.class, (Object)this.clipData), ReflectionHelpers.ClassParameter.from(IDragAndDropPermissions.class, null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.result)});
        }
        if (api <= 34) {
            return (DragEvent)ReflectionHelpers.callStaticMethod(DragEvent.class, (String)"obtain", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.action), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.x)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.y)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Object.class, (Object)this.localState), ReflectionHelpers.ClassParameter.from(ClipDescription.class, (Object)this.clipDescription), ReflectionHelpers.ClassParameter.from(ClipData.class, (Object)this.clipData), ReflectionHelpers.ClassParameter.from(SurfaceControl.class, null), ReflectionHelpers.ClassParameter.from(IDragAndDropPermissions.class, null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.result)});
        }
        return (DragEvent)ReflectionHelpers.callStaticMethod(DragEvent.class, (String)"obtain", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.action), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.x)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)Float.valueOf(this.y)), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Float.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Object.class, (Object)this.localState), ReflectionHelpers.ClassParameter.from(ClipDescription.class, (Object)this.clipDescription), ReflectionHelpers.ClassParameter.from(ClipData.class, (Object)this.clipData), ReflectionHelpers.ClassParameter.from(SurfaceControl.class, null), ReflectionHelpers.ClassParameter.from(IDragAndDropPermissions.class, null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.result)});
    }
}

