/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.StatsManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=StatsManager.class, isInAndroidSdk=false, minSdk=28)
public class ShadowStatsManager {
    private static final Map<Long, byte[]> dataMap = new HashMap<Long, byte[]>();
    private static byte[] statsMetadata = new byte[0];

    @Resetter
    public static void reset() {
        dataMap.clear();
        statsMetadata = new byte[0];
    }

    public static void addReportData(long configKey, byte[] data) {
        dataMap.put(configKey, data);
    }

    public static void setStatsMetadata(byte[] metadata) {
        statsMetadata = metadata;
    }

    @Implementation
    protected byte[] getReports(long configKey) {
        byte[] data = dataMap.getOrDefault(configKey, new byte[0]);
        dataMap.remove(configKey);
        return data;
    }

    @Implementation
    protected byte[] getStatsMetadata() {
        return statsMetadata;
    }
}

