/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.FontFamily;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.TypefaceNatives;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowLegacyTypeface;
import org.robolectric.shadows.ShadowTypeface;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Typeface.class, looseSignatures=true, minSdk=26, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeTypeface
extends ShadowTypeface {
    private static final String TAG = "ShadowNativeTypeface";
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;

    @Implementation(minSdk=31)
    protected static void __staticInitializer__() {
        if (RuntimeEnvironment.getApiLevel() <= 34) {
            Shadow.directInitialize(Typeface.class);
            Typeface.loadPreinstalledSystemFontMap();
        }
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static void buildSystemFallback(String xmlPath, String systemFontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        String fontDir = System.getProperty("robolectric.nativeruntime.fontdir");
        Preconditions.checkNotNull((Object)fontDir);
        Preconditions.checkState((boolean)new File(fontDir).isDirectory(), (Object)"Missing fonts directory");
        Preconditions.checkState((boolean)fontDir.endsWith(File.separator), (Object)"Fonts directory must end with a slash");
        ((TypefaceReflector)Reflector.reflector(TypefaceReflector.class)).buildSystemFallback(fontDir + "fonts.xml", fontDir, fontMap, fallbackMap);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static File getSystemFontConfigLocation() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        String fontDir = System.getProperty("robolectric.nativeruntime.fontdir");
        Preconditions.checkNotNull((Object)fontDir);
        Preconditions.checkState((boolean)new File(fontDir).isDirectory(), (Object)"Missing fonts directory");
        Preconditions.checkState((boolean)fontDir.endsWith(File.separator), (Object)"Fonts directory must end with a slash");
        return new File(fontDir);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static Object makeFamilyFromParsed(Object family, Object bufferForPathMap) {
        FontConfigFamilyReflector reflector = (FontConfigFamilyReflector)Reflector.reflector(FontConfigFamilyReflector.class, (Object)family);
        Map bufferForPath = (Map)bufferForPathMap;
        FontFamily fontFamily = (FontFamily)Shadow.newInstance(FontFamily.class, (Class[])new Class[]{String.class, Integer.TYPE}, (Object[])new Object[]{reflector.getLanguage(), reflector.getVariant()});
        for (FontConfig.Font font : reflector.getFonts()) {
            String fullPathName = System.getProperty("robolectric.nativeruntime.fontdir") + ((FontConfigFontReflector)Reflector.reflector(FontConfigFontReflector.class, (Object)font)).getFontName();
            ByteBuffer fontBuffer = (ByteBuffer)bufferForPath.get(fullPathName);
            if (fontBuffer == null) {
                try (FileInputStream file = new FileInputStream(fullPathName);){
                    FileChannel fileChannel = file.getChannel();
                    long fontSize = fileChannel.size();
                    fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                    bufferForPath.put(fullPathName, fontBuffer);
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)("Error mapping font file " + fullPathName));
                    continue;
                }
            }
            if (fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0)) continue;
            Log.e((String)TAG, (String)("Error creating font " + fullPathName + "#" + font.getTtcIndex()));
        }
        if (!fontFamily.freeze()) {
            Log.w((String)TAG, (String)("Unable to load Family: " + reflector.getName() + ":" + reflector.getLanguage()));
            return null;
        }
        return fontFamily;
    }

    @Implementation(minSdk=21, maxSdk=34)
    protected static long nativeCreateFromTypeface(long nativeInstance, int style) {
        return TypefaceNatives.nativeCreateFromTypeface((long)nativeInstance, (int)style);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nativeCreateFromTypefaceWithExactStyle(long nativeInstance, int weight, boolean italic) {
        return TypefaceNatives.nativeCreateFromTypefaceWithExactStyle((long)nativeInstance, (int)weight, (boolean)italic);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nativeCreateFromTypefaceWithVariation(long nativeInstance, List<FontVariationAxis> axes) {
        return TypefaceNatives.nativeCreateFromTypefaceWithVariation((long)nativeInstance, axes);
    }

    @Implementation(minSdk=21, maxSdk=34)
    protected static long nativeCreateWeightAlias(long nativeInstance, int weight) {
        return TypefaceNatives.nativeCreateWeightAlias((long)nativeInstance, (int)weight);
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static long nativeCreateFromArray(long[] familyArray, int weight, int italic) {
        return TypefaceNatives.nativeCreateFromArray((long[])familyArray, (long)0L, (int)weight, (int)italic);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nativeCreateFromArray(long[] familyArray, long fallbackTypeface, int weight, int italic) {
        return TypefaceNatives.nativeCreateFromArray((long[])familyArray, (long)fallbackTypeface, (int)weight, (int)italic);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int[] nativeGetSupportedAxes(long nativeInstance) {
        return TypefaceNatives.nativeGetSupportedAxes((long)nativeInstance);
    }

    @Implementation(minSdk=21, maxSdk=34)
    protected static void nativeSetDefault(long nativePtr) {
        TypefaceNatives.nativeSetDefault((long)nativePtr);
    }

    @Implementation(minSdk=21, maxSdk=34)
    protected static int nativeGetStyle(long nativePtr) {
        return TypefaceNatives.nativeGetStyle((long)nativePtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nativeGetWeight(long nativePtr) {
        return TypefaceNatives.nativeGetWeight((long)nativePtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static long nativeGetReleaseFunc() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return TypefaceNatives.nativeGetReleaseFunc();
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static int nativeGetFamilySize(long nativePtr) {
        return TypefaceNatives.nativeGetFamilySize((long)nativePtr);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static long nativeGetFamily(long nativePtr, int index) {
        return TypefaceNatives.nativeGetFamily((long)nativePtr, (int)index);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nativeRegisterGenericFamily(String str, long nativePtr) {
        TypefaceNatives.nativeRegisterGenericFamily((String)str, (long)nativePtr);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static int nativeWriteTypefaces(ByteBuffer buffer, long[] nativePtrs) {
        return TypefaceNatives.nativeWriteTypefaces((ByteBuffer)buffer, (long[])nativePtrs);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static int nativeWriteTypefaces(ByteBuffer buffer, int position, long[] nativePtrs) {
        return ShadowNativeTypeface.nativeWriteTypefaces(buffer, nativePtrs);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected static long[] nativeReadTypefaces(ByteBuffer buffer) {
        return TypefaceNatives.nativeReadTypefaces((ByteBuffer)buffer);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static long[] nativeReadTypefaces(ByteBuffer buffer, int position) {
        return ShadowNativeTypeface.nativeReadTypefaces(buffer);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nativeForceSetStaticFinalField(String fieldName, Typeface typeface) {
        TypefaceNatives.nativeForceSetStaticFinalField((String)fieldName, (Typeface)typeface);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static void nativeAddFontCollections(long nativePtr) {
        TypefaceNatives.nativeAddFontCollections((long)nativePtr);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected static void nativeRegisterLocaleList(String locales) {
    }

    static void ensureInitialized() {
        try {
            Class.forName("android.graphics.Typeface");
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Unable to load Typeface", e);
        }
    }

    @Override
    public ShadowTypeface.FontDesc getFontDescription() {
        throw new UnsupportedOperationException("Legacy ShadowTypeface description APIs are not supported");
    }

    @ForType(value=Typeface.class)
    static interface TypefaceReflector {
        @Static
        @Direct
        @CanIgnoreReturnValue
        public FontConfig.Alias[] buildSystemFallback(String var1, String var2, ArrayMap<String, Typeface> var3, ArrayMap<String, FontFamily[]> var4);
    }

    @ForType(className="android.text.FontConfig$Family")
    static interface FontConfigFamilyReflector {
        public String getLanguage();

        public int getVariant();

        public FontConfig.Font[] getFonts();

        public String getName();
    }

    @ForType(className="android.text.FontConfig$Font")
    static interface FontConfigFontReflector {
        public String getFontName();
    }

    @Implements(value=Typeface.Builder.class, minSdk=28, shadowPicker=Picker.class, isInAndroidSdk=false)
    public static class ShadowNativeTypefaceBuilder {

        public static final class Picker
        extends GraphicsShadowPicker<Object> {
            public Picker() {
                super(ShadowLegacyTypeface.ShadowBuilder.class, ShadowNativeTypefaceBuilder.class);
            }
        }
    }
}

