/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.displayhash.DisplayHash;
import android.view.displayhash.DisplayHashManager;
import android.view.displayhash.VerifiedDisplayHash;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=DisplayHashManager.class, isInAndroidSdk=false)
public class ShadowDisplayHashManager {
    private static VerifiedDisplayHash verifyDisplayHashResult;
    private static Set<String> supportedHashAlgorithms;

    public static void setVerifyDisplayHashResult(VerifiedDisplayHash verifyDisplayHashResult) {
        ShadowDisplayHashManager.verifyDisplayHashResult = verifyDisplayHashResult;
    }

    public static void setSupportedHashAlgorithms(Collection<String> supportedHashAlgorithms) {
        ShadowDisplayHashManager.supportedHashAlgorithms = supportedHashAlgorithms == null ? null : ImmutableSet.copyOf(supportedHashAlgorithms);
    }

    @Implementation(minSdk=31)
    protected Set<String> getSupportedHashAlgorithms() {
        return (Set)Preconditions.checkNotNull(supportedHashAlgorithms);
    }

    @Implementation(minSdk=31)
    protected VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) {
        return verifyDisplayHashResult;
    }

    static {
        supportedHashAlgorithms = ImmutableSet.of((Object)"PHASH");
    }
}

