/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CarrierConfigManager.class, minSdk=23)
public class ShadowCarrierConfigManager {
    private final HashMap<Integer, PersistableBundle> bundles = new HashMap();
    private final HashMap<Integer, PersistableBundle> overrideBundles = new HashMap();
    private boolean readPhoneStatePermission = true;

    @Implementation
    public PersistableBundle getConfigForSubId(int subId) {
        this.checkReadPhoneStatePermission();
        if (this.overrideBundles.containsKey(subId) && this.overrideBundles.get(subId) != null) {
            return this.overrideBundles.get(subId);
        }
        if (this.bundles.containsKey(subId)) {
            return this.bundles.get(subId);
        }
        return new PersistableBundle();
    }

    @Implementation(minSdk=34)
    protected PersistableBundle getConfigForSubId(int subId, String ... keys) {
        Preconditions.checkNotNull((Object)keys);
        Preconditions.checkArgument((keys.length == 0 ? 1 : 0) != 0, (Object)"filtering by keys is not currently supported in Robolectric");
        return this.getConfigForSubId(subId);
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        this.readPhoneStatePermission = readPhoneStatePermission;
    }

    public void setConfigForSubId(int subId, PersistableBundle config) {
        this.bundles.put(subId, config);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected void overrideConfig(int subId, PersistableBundle config) {
        this.overrideBundles.put(subId, config);
    }

    private void checkReadPhoneStatePermission() {
        if (!this.readPhoneStatePermission) {
            throw new SecurityException();
        }
    }
}

