/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.Call;
import android.telecom.CallScreeningService;
import com.android.internal.telecom.ICallScreeningAdapter;
import java.util.Optional;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CallScreeningService.class)
public final class ShadowCallScreeningService {
    @RealObject
    private CallScreeningService realObject;
    private Optional<RespondToCallInput> lastRespondToCallInput = Optional.empty();

    @Implementation(minSdk=24)
    protected void respondToCall(Call.Details callDetails, CallScreeningService.CallResponse response) {
        this.lastRespondToCallInput = Optional.of(new RespondToCallInput(callDetails, response));
        if (this.shouldForwardResponseToRealObject()) {
            ((CallScreeningServiceReflector)Reflector.reflector(CallScreeningServiceReflector.class, (Object)this.realObject)).respondToCall(callDetails, response);
        }
    }

    private boolean shouldForwardResponseToRealObject() {
        return ((CallScreeningServiceReflector)Reflector.reflector(CallScreeningServiceReflector.class, (Object)this.realObject)).getCallScreeningAdapter() != null;
    }

    public Optional<RespondToCallInput> getLastRespondToCallInput() {
        return this.lastRespondToCallInput;
    }

    public static final class RespondToCallInput {
        private Call.Details callDetails;
        private CallScreeningService.CallResponse callResponse;

        public RespondToCallInput(Call.Details callDetails, CallScreeningService.CallResponse callResponse) {
            this.callDetails = callDetails;
            this.callResponse = callResponse;
        }

        public Call.Details getCallDetails() {
            return this.callDetails;
        }

        public CallScreeningService.CallResponse getCallResponse() {
            return this.callResponse;
        }
    }

    @ForType(value=CallScreeningService.class)
    static interface CallScreeningServiceReflector {
        @Accessor(value="mCallScreeningAdapter")
        public ICallScreeningAdapter getCallScreeningAdapter();

        @Direct
        public void respondToCall(Call.Details var1, CallScreeningService.CallResponse var2);
    }
}

