/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.google.common.collect.ImmutableSet;
import org.robolectric.annotation.SQLiteMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.ShadowPicker;

public class SQLiteShadowPicker<T>
implements ShadowPicker<T> {
    private final Class<? extends T> legacyShadowClass;
    private final Class<? extends T> nativeShadowClass;
    private static final ImmutableSet<String> AFFECTED_CLASSES = ImmutableSet.of((Object)"android.database.CursorWindow", (Object)"android.database.sqlite.SQLiteConnection");

    public SQLiteShadowPicker(Class<? extends T> legacyShadowClass, Class<? extends T> nativeShadowClass) {
        this.legacyShadowClass = legacyShadowClass;
        this.nativeShadowClass = nativeShadowClass;
    }

    public Class<? extends T> pickShadowClass() {
        if (ConfigurationRegistry.get(SQLiteMode.Mode.class) == SQLiteMode.Mode.NATIVE) {
            return this.nativeShadowClass;
        }
        return this.legacyShadowClass;
    }

    public static ImmutableSet<String> getAffectedClasses() {
        return AFFECTED_CLASSES;
    }
}

