/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import com.android.i18n.timezone.internal.BufferIterator;
import com.android.i18n.timezone.internal.MemoryMappedFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.Streams;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=MemoryMappedFile.class, isInAndroidSdk=false, minSdk=31)
public class ShadowMemoryMappedFileS {
    protected byte[] bytes;
    private static final String TZ_DATA_1 = "/misc/zoneinfo/tzdata";
    private static final String TZ_DATA_2 = "/usr/share/zoneinfo/tzdata";
    private static final String TZ_DATA_3 = "/misc/zoneinfo/current/tzdata";
    private static final String TZ_DATA_4 = "/etc/tz/tzdata";

    @Implementation
    public static MemoryMappedFile mmapRO(String path) throws Throwable {
        if (path.endsWith(TZ_DATA_1) || path.endsWith(TZ_DATA_2) || path.endsWith(TZ_DATA_3) || path.endsWith(TZ_DATA_4)) {
            InputStream is = MemoryMappedFile.class.getResourceAsStream(TZ_DATA_2);
            if (is == null) {
                throw new ErrnoException("open", -1);
            }
            try {
                MemoryMappedFile memoryMappedFile = new MemoryMappedFile(0L, 0L);
                ShadowMemoryMappedFileS shadowMemoryMappedFile = (ShadowMemoryMappedFileS)Shadow.extract((Object)memoryMappedFile);
                shadowMemoryMappedFile.bytes = Streams.readFully((InputStream)is);
                return memoryMappedFile;
            }
            catch (IOException e) {
                throw new ErrnoException("mmap", -1);
            }
        }
        throw new IllegalArgumentException("Unknown file for mmap: '" + path);
    }

    @Implementation
    public synchronized void close() throws Exception {
        this.bytes = null;
    }

    @Implementation
    public BufferIterator bigEndianIterator() {
        return this.getHeapBufferIterator(ByteOrder.BIG_ENDIAN);
    }

    @Implementation
    public BufferIterator littleEndianIterator() {
        return this.getHeapBufferIterator(ByteOrder.LITTLE_ENDIAN);
    }

    protected BufferIterator getHeapBufferIterator(ByteOrder endianness) {
        return new RoboBufferIterator(this.bytes, endianness);
    }

    @Implementation
    public int size() {
        return this.bytes.length;
    }

    protected static class RoboBufferIterator
    extends BufferIterator {
        protected final ByteBuffer buffer;

        public RoboBufferIterator(byte[] buffer, ByteOrder order) {
            this.buffer = ByteBuffer.wrap(buffer);
        }

        public void seek(int offset) {
            ((Buffer)this.buffer).position(offset);
        }

        public void skip(int byteCount) {
            ((Buffer)this.buffer).position(this.buffer.position() + byteCount);
        }

        public int pos() {
            return 0;
        }

        public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
            System.arraycopy(this.buffer.array(), this.buffer.position(), dst, dstOffset, byteCount);
            this.skip(byteCount);
        }

        public byte readByte() {
            return this.buffer.get();
        }

        public int readInt() {
            return this.buffer.getInt();
        }

        public void readIntArray(int[] dst, int dstOffset, int intCount) {
            for (int i = 0; i < intCount; ++i) {
                dst[dstOffset + i] = this.buffer.getInt();
            }
        }

        public void readLongArray(long[] dst, int dstOffset, int longCount) {
            for (int i = 0; i < longCount; ++i) {
                dst[dstOffset + i] = this.buffer.getLong();
            }
        }

        public short readShort() {
            return this.buffer.getShort();
        }
    }
}

