/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.companion.AssociationInfo;
import android.net.MacAddress;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class AssociationInfoBuilder {
    private int id;
    private int userId;
    private String packageName;
    private String deviceMacAddress;
    private CharSequence displayName;
    private String deviceProfile;
    private boolean selfManaged;
    private boolean notifyOnDeviceNearby;
    private long approvedMs;
    private long lastTimeConnectedMs;

    private AssociationInfoBuilder() {
    }

    public static AssociationInfoBuilder newBuilder() {
        return new AssociationInfoBuilder();
    }

    public AssociationInfoBuilder setId(int id2) {
        this.id = id2;
        return this;
    }

    public AssociationInfoBuilder setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public AssociationInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public AssociationInfoBuilder setDeviceMacAddress(String deviceMacAddress) {
        this.deviceMacAddress = deviceMacAddress;
        return this;
    }

    public AssociationInfoBuilder setDisplayName(CharSequence displayName) {
        this.displayName = displayName;
        return this;
    }

    public AssociationInfoBuilder setDeviceProfile(String deviceProfile) {
        this.deviceProfile = deviceProfile;
        return this;
    }

    public AssociationInfoBuilder setSelfManaged(boolean selfManaged) {
        this.selfManaged = selfManaged;
        return this;
    }

    public AssociationInfoBuilder setNotifyOnDeviceNearby(boolean notifyOnDeviceNearby) {
        this.notifyOnDeviceNearby = notifyOnDeviceNearby;
        return this;
    }

    public AssociationInfoBuilder setApprovedMs(long approvedMs) {
        this.approvedMs = approvedMs;
        return this;
    }

    public AssociationInfoBuilder setLastTimeConnectedMs(long lastTimeConnectedMs) {
        this.lastTimeConnectedMs = lastTimeConnectedMs;
        return this;
    }

    public AssociationInfo build() {
        if (RuntimeEnvironment.getApiLevel() < 10000) {
            return new AssociationInfo(this.id, this.userId, this.packageName, MacAddress.fromString((String)this.deviceMacAddress), this.displayName, this.deviceProfile, this.selfManaged, this.notifyOnDeviceNearby, this.approvedMs, this.lastTimeConnectedMs);
        }
        try {
            return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)MacAddress.fromString((String)this.deviceMacAddress)), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Class.forName("android.companion.AssociatedDevice"), null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

