/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityService;
import android.os.Handler;
import android.os.Looper;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=AccessibilityService.SoftKeyboardController.class, minSdk=24)
public class ShadowSoftKeyboardController {
    @RealObject
    private AccessibilityService.SoftKeyboardController realObject;
    private final HashMap<AccessibilityService.SoftKeyboardController.OnShowModeChangedListener, Handler> listeners = new HashMap();
    private int showMode = 0;

    @Implementation
    protected void addOnShowModeChangedListener(AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener, Handler handler) {
        this.listeners.put(listener, handler);
    }

    @Implementation
    protected void addOnShowModeChangedListener(AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener) {
        this.listeners.put(listener, new Handler(Looper.getMainLooper()));
    }

    @Implementation
    protected int getShowMode() {
        return this.showMode;
    }

    @Implementation
    protected boolean setShowMode(int showMode) {
        this.showMode = showMode;
        this.notifyOnShowModeChangedListeners();
        return true;
    }

    @Implementation
    protected boolean removeOnShowModeChangedListener(AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener) {
        if (!this.listeners.containsKey(listener)) {
            return false;
        }
        this.listeners.remove(listener);
        return true;
    }

    private void notifyOnShowModeChangedListeners() {
        for (AccessibilityService.SoftKeyboardController.OnShowModeChangedListener listener : this.listeners.keySet()) {
            Handler handler = this.listeners.get(listener);
            handler.post(() -> listener.onShowModeChanged(this.realObject, this.showMode));
        }
    }
}

