/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.safetycenter.SafetyCenterManager;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=SafetyCenterManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowSafetyCenterManager {
    private final Map<String, SafetySourceData> dataById = new HashMap<String, SafetySourceData>();
    private final Map<String, SafetyEvent> eventsById = new HashMap<String, SafetyEvent>();
    private final Map<String, SafetySourceErrorDetails> errorsById = new HashMap<String, SafetySourceErrorDetails>();
    private boolean enabled = false;

    @Implementation
    protected boolean isSafetyCenterEnabled() {
        return this.enabled;
    }

    @Implementation
    protected void setSafetySourceData(@NonNull String safetySourceId, @Nullable SafetySourceData safetySourceData, @NonNull SafetyEvent safetyEvent) {
        if (this.isSafetyCenterEnabled()) {
            this.dataById.put(safetySourceId, safetySourceData);
            this.eventsById.put(safetySourceId, safetyEvent);
        }
    }

    @Implementation
    protected SafetySourceData getSafetySourceData(@NonNull String safetySourceId) {
        if (this.isSafetyCenterEnabled()) {
            return this.dataById.get(safetySourceId);
        }
        return null;
    }

    @Implementation
    protected void reportSafetySourceError(@NonNull String safetySourceId, @NonNull SafetySourceErrorDetails safetySourceErrorDetails) {
        if (this.isSafetyCenterEnabled()) {
            this.errorsById.put(safetySourceId, safetySourceErrorDetails);
        }
    }

    public void setSafetyCenterEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SafetyEvent getLastSafetyEvent(@NonNull String safetySourceId) {
        return this.eventsById.get(safetySourceId);
    }

    public SafetySourceErrorDetails getLastSafetySourceError(@NonNull String safetySourceId) {
        return this.errorsById.get(safetySourceId);
    }
}

