/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import java.time.DateTimeException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSystemClock;

@Implements(value=SystemClock.class, isInAndroidSdk=false, shadowPicker=ShadowSystemClock.Picker.class)
public class ShadowPausedSystemClock
extends ShadowSystemClock {
    private static final long INITIAL_TIME = 100L;
    private static final int MILLIS_PER_NANO = 1000000;
    @GuardedBy(value="ShadowPausedSystemClock.class")
    private static long currentTimeMillis = 100L;
    private static final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private static final List<Listener> staticListeners = new CopyOnWriteArrayList<Listener>();

    static void addListener(Listener listener) {
        listeners.add(listener);
    }

    static void removeListener(Listener listener) {
        listeners.remove(listener);
        staticListeners.remove(listener);
    }

    static void addStaticListener(Listener listener) {
        staticListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void sleep(long millis) {
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            currentTimeMillis += millis;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return;
        }
    }

    private static void informListeners() {
        for (Listener listener : listeners) {
            listener.onClockAdvanced();
        }
        for (Listener listener : staticListeners) {
            listener.onClockAdvanced();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static boolean setCurrentTimeMillis(long millis) {
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            if (currentTimeMillis > millis) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            if (currentTimeMillis == millis) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return true;
            }
            currentTimeMillis = millis;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return true;
        }
    }

    @Implementation
    protected static synchronized long uptimeMillis() {
        return currentTimeMillis;
    }

    @Implementation
    protected static long elapsedRealtime() {
        return ShadowPausedSystemClock.uptimeMillis();
    }

    @Implementation(minSdk=17)
    protected static long elapsedRealtimeNanos() {
        return ShadowPausedSystemClock.elapsedRealtime() * 1000000L;
    }

    @Implementation
    protected static long currentThreadTimeMillis() {
        return ShadowPausedSystemClock.uptimeMillis();
    }

    @HiddenApi
    @Implementation
    protected static long currentThreadTimeMicro() {
        return ShadowPausedSystemClock.uptimeMillis() * 1000L;
    }

    @HiddenApi
    @Implementation
    protected static long currentTimeMicro() {
        return ShadowPausedSystemClock.currentThreadTimeMicro();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected static synchronized long currentNetworkTimeMillis() {
        if (networkTimeAvailable) {
            return currentTimeMillis;
        }
        throw new DateTimeException("Network time not available");
    }

    @Resetter
    public static synchronized void reset() {
        currentTimeMillis = 100L;
        ShadowSystemClock.reset();
        listeners.clear();
    }

    static interface Listener {
        public void onClockAdvanced();
    }
}

