/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.graphics.text.MeasuredText;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.MeasuredTextBuilderNatives;
import org.robolectric.nativeruntime.MeasuredTextNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowMeasuredTextBuilder;

@Implements(value=MeasuredText.class, minSdk=29, shadowPicker=Picker.class)
public class ShadowNativeMeasuredText {
    @Implementation
    protected static float nGetWidth(long nativePtr, int start, int end) {
        return MeasuredTextNatives.nGetWidth((long)nativePtr, (int)start, (int)end);
    }

    @Implementation
    protected static long nGetReleaseFunc() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return MeasuredTextNatives.nGetReleaseFunc();
    }

    @Implementation
    protected static int nGetMemoryUsage(long nativePtr) {
        return MeasuredTextNatives.nGetMemoryUsage((long)nativePtr);
    }

    @Implementation
    protected static void nGetBounds(long nativePtr, char[] buf, int start, int end, Rect rect) {
        MeasuredTextNatives.nGetBounds((long)nativePtr, (char[])buf, (int)start, (int)end, (Rect)rect);
    }

    @Implementation
    protected static float nGetCharWidthAt(long nativePtr, int offset) {
        return MeasuredTextNatives.nGetCharWidthAt((long)nativePtr, (int)offset);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(null, ShadowNativeMeasuredText.class);
        }
    }

    @Implements(value=MeasuredText.Builder.class, minSdk=29, shadowPicker=Picker.class)
    public static class ShadowNativeMeasuredTextBuilder {
        @Implementation
        protected static long nInitBuilder() {
            return MeasuredTextBuilderNatives.nInitBuilder();
        }

        @Implementation(maxSdk=32)
        protected static void nAddStyleRun(long nativeBuilderPtr, long paintPtr, int start, int end, boolean isRtl) {
            MeasuredTextBuilderNatives.nAddStyleRun((long)nativeBuilderPtr, (long)paintPtr, (int)start, (int)end, (boolean)isRtl);
        }

        @Implementation(minSdk=33)
        protected static void nAddStyleRun(long nativeBuilderPtr, long paintPtr, int lineBreakStyle, int lineBreakWordStyle, int start, int end, boolean isRtl) {
            MeasuredTextBuilderNatives.nAddStyleRun((long)nativeBuilderPtr, (long)paintPtr, (int)start, (int)end, (boolean)isRtl);
        }

        @Implementation
        protected static void nAddReplacementRun(long nativeBuilderPtr, long paintPtr, int start, int end, float width) {
            MeasuredTextBuilderNatives.nAddReplacementRun((long)nativeBuilderPtr, (long)paintPtr, (int)start, (int)end, (float)width);
        }

        @Implementation(maxSdk=32)
        protected static long nBuildMeasuredText(long nativeBuilderPtr, long hintMtPtr, char[] text, boolean computeHyphenation, boolean computeLayout) {
            return MeasuredTextBuilderNatives.nBuildMeasuredText((long)nativeBuilderPtr, (long)hintMtPtr, (char[])text, (boolean)computeHyphenation, (boolean)computeLayout);
        }

        @Implementation(minSdk=33)
        protected static long nBuildMeasuredText(long nativeBuilderPtr, long hintMtPtr, char[] text, boolean computeHyphenation, boolean computeLayout, boolean fastHyphenationMode) {
            return MeasuredTextBuilderNatives.nBuildMeasuredText((long)nativeBuilderPtr, (long)hintMtPtr, (char[])text, (boolean)computeHyphenation, (boolean)computeLayout);
        }

        @Implementation
        protected static void nFreeBuilder(long nativeBuilderPtr) {
            MeasuredTextBuilderNatives.nFreeBuilder((long)nativeBuilderPtr);
        }

        public static final class Picker
        extends GraphicsShadowPicker<Object> {
            public Picker() {
                super(ShadowMeasuredTextBuilder.class, ShadowNativeMeasuredTextBuilder.class);
            }
        }
    }
}

