/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AppComponentFactory;
import android.app.Application;
import android.app.LoadedApk;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=LoadedApk.class, isInAndroidSdk=false)
public class ShadowLoadedApk {
    @RealObject
    private LoadedApk realLoadedApk;
    private boolean isClassLoaderInitialized = false;
    private final Object classLoaderLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public ClassLoader getClassLoader() {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            Object object = this.classLoaderLock;
            synchronized (object) {
                if (!this.isClassLoaderInitialized) {
                    this.isClassLoaderInitialized = true;
                    this.tryInitAppComponentFactory(this.realLoadedApk);
                }
            }
        }
        return this.getClass().getClassLoader();
    }

    @Implementation(minSdk=26)
    public ClassLoader getSplitClassLoader(String splitName) throws PackageManager.NameNotFoundException {
        return this.getClass().getClassLoader();
    }

    private void tryInitAppComponentFactory(LoadedApk realLoadedApk) {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            ApplicationInfo applicationInfo = realLoadedApk.getApplicationInfo();
            if (applicationInfo == null || applicationInfo.appComponentFactory == null) {
                return;
            }
            _LoadedApk_ loadedApkReflector = (_LoadedApk_)Reflector.reflector(_LoadedApk_.class, (Object)realLoadedApk);
            if (!loadedApkReflector.getIncludeCode()) {
                return;
            }
            String fullQualifiedClassName = this.calculateFullQualifiedClassName(applicationInfo.appComponentFactory, applicationInfo.packageName);
            AppComponentFactory factory = (AppComponentFactory)Shadow.newInstanceOf((String)fullQualifiedClassName);
            if (factory == null) {
                factory = new AppComponentFactory();
            }
            loadedApkReflector.setAppFactory(factory);
        }
    }

    private String calculateFullQualifiedClassName(String className, String packageName) {
        if (packageName == null) {
            return className;
        }
        return className.startsWith(".") ? packageName + className : className;
    }

    @ForType(value=LoadedApk.class)
    public static interface _LoadedApk_ {
        @Accessor(value="mApplication")
        public void setApplication(Application var1);

        @Accessor(value="mResources")
        public void setResources(Resources var1);

        @Accessor(value="mIncludeCode")
        public boolean getIncludeCode();

        @Accessor(value="mAppComponentFactory")
        public void setAppFactory(Object var1);
    }
}

