/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import java.awt.geom.AffineTransform;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMatrix;

@Implements(value=Matrix.class, isInAndroidSdk=false)
public class ShadowLegacyMatrix
extends ShadowMatrix {
    private static final float EPSILON = 0.001f;
    private final Deque<String> preOps = new ArrayDeque<String>();
    private final Deque<String> postOps = new ArrayDeque<String>();
    private final Map<String, String> setOps = new LinkedHashMap<String, String>();
    private SimpleMatrix simpleMatrix = SimpleMatrix.access$000();

    @Implementation
    protected void __constructor__(Matrix src) {
        this.set(src);
    }

    @Override
    public List<String> getPreOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.preOps));
    }

    @Override
    public List<String> getPostOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.postOps));
    }

    @Override
    public Map<String, String> getSetOperations() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.setOps));
    }

    @Implementation
    protected boolean isIdentity() {
        return this.simpleMatrix.equals(SimpleMatrix.IDENTITY);
    }

    @Implementation(minSdk=21)
    protected boolean isAffine() {
        return this.simpleMatrix.isAffine();
    }

    @Implementation
    protected boolean rectStaysRect() {
        return this.simpleMatrix.rectStaysRect();
    }

    @Implementation
    protected void getValues(float[] values) {
        this.simpleMatrix.getValues(values);
    }

    @Implementation
    protected void setValues(float[] values) {
        this.simpleMatrix = new SimpleMatrix(values);
    }

    @Implementation
    protected void set(Matrix src) {
        this.reset();
        if (src != null) {
            ShadowLegacyMatrix shadowMatrix = (ShadowLegacyMatrix)Shadow.extract((Object)src);
            this.preOps.addAll(shadowMatrix.preOps);
            this.postOps.addAll(shadowMatrix.postOps);
            this.setOps.putAll(shadowMatrix.setOps);
            this.simpleMatrix = new SimpleMatrix(ShadowLegacyMatrix.getSimpleMatrix(src));
        }
    }

    @Implementation
    protected void reset() {
        this.preOps.clear();
        this.postOps.clear();
        this.setOps.clear();
        this.simpleMatrix = SimpleMatrix.newIdentityMatrix();
    }

    @Implementation
    protected void setTranslate(float dx, float dy) {
        this.setOps.put("translate", dx + " " + dy);
        this.simpleMatrix = SimpleMatrix.translate(dx, dy);
    }

    @Implementation
    protected void setScale(float sx, float sy, float px, float py) {
        this.setOps.put("scale", sx + " " + sy + " " + px + " " + py);
        this.simpleMatrix = SimpleMatrix.scale(sx, sy, px, py);
    }

    @Implementation
    protected void setScale(float sx, float sy) {
        this.setOps.put("scale", sx + " " + sy);
        this.simpleMatrix = SimpleMatrix.scale(sx, sy);
    }

    @Implementation
    protected void setRotate(float degrees, float px, float py) {
        this.setOps.put("rotate", degrees + " " + px + " " + py);
        this.simpleMatrix = SimpleMatrix.rotate(degrees, px, py);
    }

    @Implementation
    protected void setRotate(float degrees) {
        this.setOps.put("rotate", Float.toString(degrees));
        this.simpleMatrix = SimpleMatrix.rotate(degrees);
    }

    @Implementation
    protected void setSinCos(float sinValue, float cosValue, float px, float py) {
        this.setOps.put("sincos", sinValue + " " + cosValue + " " + px + " " + py);
        this.simpleMatrix = SimpleMatrix.sinCos(sinValue, cosValue, px, py);
    }

    @Implementation
    protected void setSinCos(float sinValue, float cosValue) {
        this.setOps.put("sincos", sinValue + " " + cosValue);
        this.simpleMatrix = SimpleMatrix.sinCos(sinValue, cosValue);
    }

    @Implementation
    protected void setSkew(float kx, float ky, float px, float py) {
        this.setOps.put("skew", kx + " " + ky + " " + px + " " + py);
        this.simpleMatrix = SimpleMatrix.skew(kx, ky, px, py);
    }

    @Implementation
    protected void setSkew(float kx, float ky) {
        this.setOps.put("skew", kx + " " + ky);
        this.simpleMatrix = SimpleMatrix.skew(kx, ky);
    }

    @Implementation
    protected boolean setConcat(Matrix a, Matrix b) {
        this.simpleMatrix = ShadowLegacyMatrix.getSimpleMatrix(a).multiply(ShadowLegacyMatrix.getSimpleMatrix(b));
        return true;
    }

    @Implementation
    protected boolean preTranslate(float dx, float dy) {
        this.preOps.addFirst("translate " + dx + " " + dy);
        return this.preConcat(SimpleMatrix.translate(dx, dy));
    }

    @Implementation
    protected boolean preScale(float sx, float sy, float px, float py) {
        this.preOps.addFirst("scale " + sx + " " + sy + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.scale(sx, sy, px, py));
    }

    @Implementation
    protected boolean preScale(float sx, float sy) {
        this.preOps.addFirst("scale " + sx + " " + sy);
        return this.preConcat(SimpleMatrix.scale(sx, sy));
    }

    @Implementation
    protected boolean preRotate(float degrees, float px, float py) {
        this.preOps.addFirst("rotate " + degrees + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.rotate(degrees, px, py));
    }

    @Implementation
    protected boolean preRotate(float degrees) {
        this.preOps.addFirst("rotate " + Float.toString(degrees));
        return this.preConcat(SimpleMatrix.rotate(degrees));
    }

    @Implementation
    protected boolean preSkew(float kx, float ky, float px, float py) {
        this.preOps.addFirst("skew " + kx + " " + ky + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.skew(kx, ky, px, py));
    }

    @Implementation
    protected boolean preSkew(float kx, float ky) {
        this.preOps.addFirst("skew " + kx + " " + ky);
        return this.preConcat(SimpleMatrix.skew(kx, ky));
    }

    @Implementation
    protected boolean preConcat(Matrix other) {
        this.preOps.addFirst("matrix " + other);
        return this.preConcat(ShadowLegacyMatrix.getSimpleMatrix(other));
    }

    @Implementation
    protected boolean postTranslate(float dx, float dy) {
        this.postOps.addLast("translate " + dx + " " + dy);
        return this.postConcat(SimpleMatrix.translate(dx, dy));
    }

    @Implementation
    protected boolean postScale(float sx, float sy, float px, float py) {
        this.postOps.addLast("scale " + sx + " " + sy + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.scale(sx, sy, px, py));
    }

    @Implementation
    protected boolean postScale(float sx, float sy) {
        this.postOps.addLast("scale " + sx + " " + sy);
        return this.postConcat(SimpleMatrix.scale(sx, sy));
    }

    @Implementation
    protected boolean postRotate(float degrees, float px, float py) {
        this.postOps.addLast("rotate " + degrees + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.rotate(degrees, px, py));
    }

    @Implementation
    protected boolean postRotate(float degrees) {
        this.postOps.addLast("rotate " + Float.toString(degrees));
        return this.postConcat(SimpleMatrix.rotate(degrees));
    }

    @Implementation
    protected boolean postSkew(float kx, float ky, float px, float py) {
        this.postOps.addLast("skew " + kx + " " + ky + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.skew(kx, ky, px, py));
    }

    @Implementation
    protected boolean postSkew(float kx, float ky) {
        this.postOps.addLast("skew " + kx + " " + ky);
        return this.postConcat(SimpleMatrix.skew(kx, ky));
    }

    @Implementation
    protected boolean postConcat(Matrix other) {
        this.postOps.addLast("matrix " + other);
        return this.postConcat(ShadowLegacyMatrix.getSimpleMatrix(other));
    }

    @Implementation
    protected boolean invert(Matrix inverse) {
        SimpleMatrix inverseMatrix = this.simpleMatrix.invert();
        if (inverseMatrix != null) {
            if (inverse != null) {
                ShadowLegacyMatrix shadowInverse = (ShadowLegacyMatrix)Shadow.extract((Object)inverse);
                shadowInverse.simpleMatrix = inverseMatrix;
            }
            return true;
        }
        return false;
    }

    boolean hasPerspective() {
        return this.simpleMatrix.mValues[6] != 0.0f || this.simpleMatrix.mValues[7] != 0.0f || this.simpleMatrix.mValues[8] != 1.0f;
    }

    protected AffineTransform getAffineTransform() {
        return new AffineTransform(this.simpleMatrix.mValues[0], this.simpleMatrix.mValues[3], this.simpleMatrix.mValues[1], this.simpleMatrix.mValues[4], this.simpleMatrix.mValues[2], this.simpleMatrix.mValues[5]);
    }

    public PointF mapPoint(float x, float y) {
        return this.simpleMatrix.transform(new PointF(x, y));
    }

    public PointF mapPoint(PointF point) {
        return this.simpleMatrix.transform(point);
    }

    @Implementation
    protected boolean mapRect(RectF destination, RectF source) {
        PointF leftTop = this.mapPoint(source.left, source.top);
        PointF rightBottom = this.mapPoint(source.right, source.bottom);
        destination.set(Math.min(leftTop.x, rightBottom.x), Math.min(leftTop.y, rightBottom.y), Math.max(leftTop.x, rightBottom.x), Math.max(leftTop.y, rightBottom.y));
        return true;
    }

    @Implementation
    protected void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        for (int i = 0; i < pointCount; ++i) {
            PointF mapped = this.mapPoint(src[srcIndex + i * 2], src[srcIndex + i * 2 + 1]);
            dst[dstIndex + i * 2] = mapped.x;
            dst[dstIndex + i * 2 + 1] = mapped.y;
        }
    }

    @Implementation
    protected void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        float transX = this.simpleMatrix.mValues[2];
        float transY = this.simpleMatrix.mValues[5];
        ((SimpleMatrix)this.simpleMatrix).mValues[2] = 0.0f;
        ((SimpleMatrix)this.simpleMatrix).mValues[5] = 0.0f;
        for (int i = 0; i < vectorCount; ++i) {
            PointF mapped = this.mapPoint(src[srcIndex + i * 2], src[srcIndex + i * 2 + 1]);
            dst[dstIndex + i * 2] = mapped.x;
            dst[dstIndex + i * 2 + 1] = mapped.y;
        }
        ((SimpleMatrix)this.simpleMatrix).mValues[2] = transX;
        ((SimpleMatrix)this.simpleMatrix).mValues[5] = transY;
    }

    @Implementation
    protected float mapRadius(float radius) {
        float[] src = new float[]{radius, 0.0f, 0.0f, radius};
        this.mapVectors(src, 0, src, 0, 2);
        float l1 = (float)Math.hypot(src[0], src[1]);
        float l2 = (float)Math.hypot(src[2], src[3]);
        return (float)Math.sqrt(l1 * l2);
    }

    @Implementation
    protected boolean setRectToRect(RectF src, RectF dst, Matrix.ScaleToFit stf) {
        if (src.isEmpty()) {
            this.reset();
            return false;
        }
        return this.simpleMatrix.setRectToRect(src, dst, stf);
    }

    @Implementation
    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return ShadowLegacyMatrix.getSimpleMatrix((Matrix)obj).equals(this.simpleMatrix);
        }
        return obj instanceof ShadowMatrix && obj.equals(this.simpleMatrix);
    }

    @Implementation(minSdk=19)
    public int hashCode() {
        return Objects.hashCode(this.simpleMatrix);
    }

    @Override
    public String getDescription() {
        return "Matrix[pre=" + this.preOps + ", set=" + this.setOps + ", post=" + this.postOps + "]";
    }

    private static SimpleMatrix getSimpleMatrix(Matrix matrix) {
        ShadowLegacyMatrix otherMatrix = (ShadowLegacyMatrix)Shadow.extract((Object)matrix);
        return otherMatrix.simpleMatrix;
    }

    private boolean postConcat(SimpleMatrix matrix) {
        this.simpleMatrix = matrix.multiply(this.simpleMatrix);
        return true;
    }

    private boolean preConcat(SimpleMatrix matrix) {
        this.simpleMatrix = this.simpleMatrix.multiply(matrix);
        return true;
    }

    private static class SimpleMatrix {
        private static final SimpleMatrix IDENTITY = SimpleMatrix.newIdentityMatrix();
        private final float[] mValues;

        private static SimpleMatrix newIdentityMatrix() {
            return new SimpleMatrix(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        SimpleMatrix(SimpleMatrix matrix) {
            this.mValues = Arrays.copyOf(matrix.mValues, matrix.mValues.length);
        }

        private SimpleMatrix(float[] values) {
            if (values.length != 9) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mValues = Arrays.copyOf(values, 9);
        }

        public boolean isAffine() {
            return this.mValues[6] == 0.0f && this.mValues[7] == 0.0f && this.mValues[8] == 1.0f;
        }

        public boolean rectStaysRect() {
            float m00 = this.mValues[0];
            float m01 = this.mValues[1];
            float m10 = this.mValues[3];
            float m11 = this.mValues[4];
            return m00 == 0.0f && m11 == 0.0f && m01 != 0.0f && m10 != 0.0f || m00 != 0.0f && m11 != 0.0f && m01 == 0.0f && m10 == 0.0f;
        }

        public void getValues(float[] values) {
            if (values.length < 9) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(this.mValues, 0, values, 0, 9);
        }

        public static SimpleMatrix translate(float dx, float dy) {
            return new SimpleMatrix(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix scale(float sx, float sy, float px, float py) {
            return new SimpleMatrix(new float[]{sx, 0.0f, px * (1.0f - sx), 0.0f, sy, py * (1.0f - sy), 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix scale(float sx, float sy) {
            return new SimpleMatrix(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix rotate(float degrees, float px, float py) {
            double radians = Math.toRadians(degrees);
            float sin = (float)Math.sin(radians);
            float cos = (float)Math.cos(radians);
            return SimpleMatrix.sinCos(sin, cos, px, py);
        }

        public static SimpleMatrix rotate(float degrees) {
            double radians = Math.toRadians(degrees);
            float sin = (float)Math.sin(radians);
            float cos = (float)Math.cos(radians);
            return SimpleMatrix.sinCos(sin, cos);
        }

        public static SimpleMatrix sinCos(float sin, float cos, float px, float py) {
            return new SimpleMatrix(new float[]{cos, -sin, sin * py + (1.0f - cos) * px, sin, cos, -sin * px + (1.0f - cos) * py, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix sinCos(float sin, float cos) {
            return new SimpleMatrix(new float[]{cos, -sin, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix skew(float kx, float ky, float px, float py) {
            return new SimpleMatrix(new float[]{1.0f, kx, -kx * py, ky, 1.0f, -ky * px, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix skew(float kx, float ky) {
            return new SimpleMatrix(new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public SimpleMatrix multiply(SimpleMatrix matrix) {
            float[] values = new float[9];
            for (int i = 0; i < values.length; ++i) {
                int row = i / 3;
                int col = i % 3;
                for (int j = 0; j < 3; ++j) {
                    int n = i;
                    values[n] = values[n] + this.mValues[row * 3 + j] * matrix.mValues[j * 3 + col];
                }
            }
            return new SimpleMatrix(values);
        }

        public SimpleMatrix invert() {
            float invDet = this.inverseDeterminant();
            if (invDet == 0.0f) {
                return null;
            }
            float[] src = this.mValues;
            float[] dst = new float[]{SimpleMatrix.cross_scale(src[4], src[8], src[5], src[7], invDet), SimpleMatrix.cross_scale(src[2], src[7], src[1], src[8], invDet), SimpleMatrix.cross_scale(src[1], src[5], src[2], src[4], invDet), SimpleMatrix.cross_scale(src[5], src[6], src[3], src[8], invDet), SimpleMatrix.cross_scale(src[0], src[8], src[2], src[6], invDet), SimpleMatrix.cross_scale(src[2], src[3], src[0], src[5], invDet), SimpleMatrix.cross_scale(src[3], src[7], src[4], src[6], invDet), SimpleMatrix.cross_scale(src[1], src[6], src[0], src[7], invDet), SimpleMatrix.cross_scale(src[0], src[4], src[1], src[3], invDet)};
            return new SimpleMatrix(dst);
        }

        public PointF transform(PointF point) {
            return new PointF(point.x * this.mValues[0] + point.y * this.mValues[1] + this.mValues[2], point.x * this.mValues[3] + point.y * this.mValues[4] + this.mValues[5]);
        }

        protected boolean setRectToRect(RectF src, RectF dst, Matrix.ScaleToFit stf) {
            if (dst.isEmpty()) {
                this.mValues[7] = 0.0f;
                this.mValues[6] = 0.0f;
                this.mValues[5] = 0.0f;
                this.mValues[4] = 0.0f;
                this.mValues[3] = 0.0f;
                this.mValues[2] = 0.0f;
                this.mValues[1] = 0.0f;
                this.mValues[0] = 0.0f;
                this.mValues[8] = 1.0f;
            } else {
                float tx = dst.width() / src.width();
                float sx = dst.width() / src.width();
                float ty = dst.height() / src.height();
                float sy = dst.height() / src.height();
                boolean xLarger = false;
                if (stf != Matrix.ScaleToFit.FILL) {
                    if (sx > sy) {
                        xLarger = true;
                        sx = sy;
                    } else {
                        sy = sx;
                    }
                }
                tx = dst.left - src.left * sx;
                ty = dst.top - src.top * sy;
                if (stf == Matrix.ScaleToFit.CENTER || stf == Matrix.ScaleToFit.END) {
                    float diff = xLarger ? dst.width() - src.width() * sy : dst.height() - src.height() * sy;
                    if (stf == Matrix.ScaleToFit.CENTER) {
                        diff /= 2.0f;
                    }
                    if (xLarger) {
                        tx += diff;
                    } else {
                        ty += diff;
                    }
                }
                this.mValues[0] = sx;
                this.mValues[4] = sy;
                this.mValues[2] = tx;
                this.mValues[5] = ty;
                this.mValues[7] = 0.0f;
                this.mValues[6] = 0.0f;
                this.mValues[3] = 0.0f;
                this.mValues[1] = 0.0f;
            }
            this.mValues[8] = 1.0f;
            return true;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof SimpleMatrix && this.equals((SimpleMatrix)o);
        }

        public boolean equals(SimpleMatrix matrix) {
            if (matrix == null) {
                return false;
            }
            for (int i = 0; i < this.mValues.length; ++i) {
                if (SimpleMatrix.isNearlyZero(matrix.mValues[i] - this.mValues[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.mValues);
        }

        private static boolean isNearlyZero(float value) {
            return Math.abs(value) < 0.001f;
        }

        private static float cross(float a, float b, float c, float d) {
            return a * b - c * d;
        }

        private static float cross_scale(float a, float b, float c, float d, float scale) {
            return SimpleMatrix.cross(a, b, c, d) * scale;
        }

        private float inverseDeterminant() {
            float determinant = this.mValues[0] * SimpleMatrix.cross(this.mValues[4], this.mValues[8], this.mValues[5], this.mValues[7]) + this.mValues[1] * SimpleMatrix.cross(this.mValues[5], this.mValues[6], this.mValues[3], this.mValues[8]) + this.mValues[2] * SimpleMatrix.cross(this.mValues[3], this.mValues[7], this.mValues[4], this.mValues[6]);
            return SimpleMatrix.isNearlyZero(determinant) ? 0.0f : 1.0f / determinant;
        }
    }
}

