/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowVirtualRefBasePtr;

@Implements(value=HardwareRenderer.class, isInAndroidSdk=false, looseSignatures=true, minSdk=29)
public class ShadowHardwareRenderer {
    private static long nextCreateProxy = 0L;

    @Implementation(maxSdk=29)
    protected static long nCreateProxy(boolean translucent, long rootRenderNode) {
        return ++nextCreateProxy;
    }

    @Implementation
    protected static long nCreateTextureLayer(long nativeProxy) {
        return ShadowVirtualRefBasePtr.put(nativeProxy);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected static long nCreateProxy(boolean translucent, boolean isWideGamut, long rootRenderNode) {
        return ShadowHardwareRenderer.nCreateProxy(translucent, rootRenderNode);
    }

    @Implementation(minSdk=31)
    protected static long nCreateProxy(Object translucent, Object rootRenderNode) {
        return ShadowHardwareRenderer.nCreateProxy((Boolean)translucent, (Long)rootRenderNode);
    }

    @Implementation
    protected static Bitmap createHardwareBitmap(Object node, Object width, Object height) {
        return ShadowHardwareRenderer.createHardwareBitmap((Integer)width, (Integer)height);
    }

    private static Bitmap createHardwareBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.HARDWARE);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.setMutable(false);
        return bitmap;
    }

    @Resetter
    public static void reset() {
        nextCreateProxy = 0L;
    }
}

