/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import android.os.ParcelUuid;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BluetoothServerSocket.class)
public class ShadowBluetoothServerSocket {
    private final BlockingQueue<BluetoothSocket> sockets = new LinkedBlockingQueue<BluetoothSocket>();
    private boolean closed;

    @SuppressLint(value={"PrivateApi"})
    public static BluetoothServerSocket newInstance(int type, boolean auth, boolean encrypt, ParcelUuid uuid) {
        if (Build.VERSION.SDK_INT >= 17) {
            return (BluetoothServerSocket)Shadow.newInstance(BluetoothServerSocket.class, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE, ParcelUuid.class}, (Object[])new Object[]{type, auth, encrypt, uuid});
        }
        return (BluetoothServerSocket)Shadow.newInstance(BluetoothServerSocket.class, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE}, (Object[])new Object[]{type, auth, encrypt, ShadowBluetoothServerSocket.getPort(uuid)});
    }

    private static int getPort(ParcelUuid uuid) {
        return Math.abs(uuid.hashCode() % 30) + 1;
    }

    @Implementation
    protected BluetoothSocket accept(int timeout) throws IOException {
        BluetoothSocket socket;
        if (this.closed) {
            throw new IOException("Socket closed");
        }
        try {
            socket = timeout == -1 ? this.sockets.take() : this.sockets.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (socket == null) {
            throw new IOException("Timeout occurred");
        }
        socket.connect();
        return socket;
    }

    @Implementation
    protected void close() throws IOException {
        this.closed = true;
    }

    public BluetoothSocket deviceConnected(BluetoothDevice device) {
        BluetoothSocket socket = (BluetoothSocket)Shadow.newInstanceOf(BluetoothSocket.class);
        ReflectionHelpers.setField((Object)socket, (String)"mDevice", (Object)device);
        this.sockets.offer(socket);
        return socket;
    }
}

