/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.rtt.ResponderLocation;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class ResponderLocationBuilder {
    private Double altitude;
    private Double altitudeUncertainty;
    private Integer altitudeType;
    private Double latitudeDegrees;
    private Double latitudeUncertainty;
    private Double longitudeDegrees;
    private Double longitudeUncertainty;
    private Integer datum;
    private Integer lciVersion;
    private Boolean lciRegisteredLocationAgreement;
    private Double heightAboveFloorMeters;
    private Double heightAboveFloorUncertaintyMeters;
    private Integer expectedToMove;
    private Double floorNumber;

    private ResponderLocationBuilder() {
    }

    public static ResponderLocationBuilder newBuilder() {
        return new ResponderLocationBuilder();
    }

    public ResponderLocationBuilder setAltitude(double altitude) {
        this.altitude = altitude;
        return this;
    }

    public ResponderLocationBuilder setAltitudeUncertainty(double altitudeUncertainty) {
        this.altitudeUncertainty = altitudeUncertainty;
        return this;
    }

    public ResponderLocationBuilder setAltitudeType(int altitudeType) {
        this.altitudeType = altitudeType;
        return this;
    }

    public ResponderLocationBuilder setLatitude(double latitudeDegrees) {
        this.latitudeDegrees = latitudeDegrees;
        return this;
    }

    public ResponderLocationBuilder setLatitudeUncertainty(double latitudeUncertainty) {
        this.latitudeUncertainty = latitudeUncertainty;
        return this;
    }

    public ResponderLocationBuilder setLongitude(double longitudeDegrees) {
        this.longitudeDegrees = longitudeDegrees;
        return this;
    }

    public ResponderLocationBuilder setLongitudeUncertainty(double longitudeUncertainty) {
        this.longitudeUncertainty = longitudeUncertainty;
        return this;
    }

    public ResponderLocationBuilder setDatum(int datum) {
        this.datum = datum;
        return this;
    }

    public ResponderLocationBuilder setLciVersion(int lciVersion) {
        this.lciVersion = lciVersion;
        return this;
    }

    public ResponderLocationBuilder setLciRegisteredLocationAgreement(Boolean lciRegisteredLocationAgreement) {
        this.lciRegisteredLocationAgreement = lciRegisteredLocationAgreement;
        return this;
    }

    public ResponderLocationBuilder setHeightAboveFloorMeters(double heightAboveFloorMeters) {
        this.heightAboveFloorMeters = heightAboveFloorMeters;
        return this;
    }

    public ResponderLocationBuilder setHeightAboveFloorUncertaintyMeters(double heightAboveFloorUncertaintyMeters) {
        this.heightAboveFloorUncertaintyMeters = heightAboveFloorUncertaintyMeters;
        return this;
    }

    public ResponderLocationBuilder setExpectedToMove(int expectedToMove) {
        this.expectedToMove = expectedToMove;
        return this;
    }

    public ResponderLocationBuilder setFloorNumber(double floorNumber) {
        this.floorNumber = floorNumber;
        return this;
    }

    public ResponderLocation build() {
        ResponderLocation result = (ResponderLocation)Shadow.newInstanceOf(ResponderLocation.class);
        ResponderLocationReflector locationResponderReflector = (ResponderLocationReflector)Reflector.reflector(ResponderLocationReflector.class, (Object)result);
        locationResponderReflector.setAltitude(this.altitude == null ? 0.0 : this.altitude);
        locationResponderReflector.setAltitudeType(this.altitudeType == null ? 0 : this.altitudeType);
        locationResponderReflector.setAltitudeUncertainty(this.altitudeUncertainty == null ? 0.0 : this.altitudeUncertainty);
        locationResponderReflector.setLatitude(this.latitudeDegrees == null ? 0.0 : this.latitudeDegrees);
        locationResponderReflector.setLatitudeUncertainty(this.latitudeUncertainty == null ? 0.0 : this.latitudeUncertainty);
        locationResponderReflector.setLongitude(this.longitudeDegrees == null ? 0.0 : this.longitudeDegrees);
        locationResponderReflector.setLongitudeUncertainty(this.longitudeUncertainty == null ? 0.0 : this.longitudeUncertainty);
        locationResponderReflector.setDatum(this.datum == null ? 0 : this.datum);
        locationResponderReflector.setLciVersion(this.lciVersion == null ? 0 : this.lciVersion);
        locationResponderReflector.setLciRegisteredLocationAgreement(this.lciRegisteredLocationAgreement != null && this.lciRegisteredLocationAgreement != false);
        locationResponderReflector.setHeightAboveFloorMeters(this.heightAboveFloorMeters == null ? 0.0 : this.heightAboveFloorMeters);
        locationResponderReflector.setHeightAboveFloorUncertaintyMeters(this.heightAboveFloorUncertaintyMeters == null ? 0.0 : this.heightAboveFloorUncertaintyMeters);
        locationResponderReflector.setExpectedToMove(this.expectedToMove == null ? 0 : this.expectedToMove);
        locationResponderReflector.setFloorNumber(this.floorNumber == null ? 0.0 : this.floorNumber);
        locationResponderReflector.setIsLciValid(this.altitude != null && this.latitudeDegrees != null && this.latitudeUncertainty != null && this.longitudeDegrees != null && this.longitudeUncertainty != null && this.datum != null && this.lciVersion != null && this.lciRegisteredLocationAgreement != null && this.altitudeType != null);
        locationResponderReflector.setIsZValid(this.heightAboveFloorMeters != null && this.floorNumber != null && this.expectedToMove != null && this.heightAboveFloorUncertaintyMeters != null);
        return result;
    }

    @ForType(value=ResponderLocation.class)
    static interface ResponderLocationReflector {
        @Accessor(value="mAltitude")
        public void setAltitude(double var1);

        @Accessor(value="mAltitudeUncertainty")
        public void setAltitudeUncertainty(double var1);

        @Accessor(value="mAltitudeType")
        public void setAltitudeType(int var1);

        @Accessor(value="mLatitude")
        public void setLatitude(double var1);

        @Accessor(value="mLatitudeUncertainty")
        public void setLatitudeUncertainty(double var1);

        @Accessor(value="mLongitude")
        public void setLongitude(double var1);

        @Accessor(value="mLongitudeUncertainty")
        public void setLongitudeUncertainty(double var1);

        @Accessor(value="mDatum")
        public void setDatum(int var1);

        @Accessor(value="mLciVersion")
        public void setLciVersion(int var1);

        @Accessor(value="mLciRegisteredLocationAgreement")
        public void setLciRegisteredLocationAgreement(boolean var1);

        @Accessor(value="mHeightAboveFloorMeters")
        public void setHeightAboveFloorMeters(double var1);

        @Accessor(value="mHeightAboveFloorUncertaintyMeters")
        public void setHeightAboveFloorUncertaintyMeters(double var1);

        @Accessor(value="mExpectedToMove")
        public void setExpectedToMove(int var1);

        @Accessor(value="mFloorNumber")
        public void setFloorNumber(double var1);

        @Accessor(value="mIsLciValid")
        public void setIsLciValid(boolean var1);

        @Accessor(value="mIsZValid")
        public void setIsZValid(boolean var1);
    }
}

