/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.BarringInfo;
import android.telephony.CellIdentity;
import android.util.SparseArray;
import androidx.annotation.RequiresApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.robolectric.util.ReflectionHelpers;

@RequiresApi(value=30)
public class BarringInfoBuilder {
    private CellIdentity barringCellIdentity;
    private final SparseArray<BarringInfo.BarringServiceInfo> barringServiceInfos = new SparseArray();

    private BarringInfoBuilder() {
    }

    public static BarringInfoBuilder newBuilder() {
        return new BarringInfoBuilder();
    }

    @CanIgnoreReturnValue
    public BarringInfoBuilder setCellIdentity(CellIdentity cellIdentity) {
        this.barringCellIdentity = cellIdentity;
        return this;
    }

    @CanIgnoreReturnValue
    public BarringInfoBuilder addBarringServiceInfo(int barringServiceType, BarringInfo.BarringServiceInfo barringServiceInfo) {
        this.validateBarringServiceType(barringServiceType);
        this.barringServiceInfos.put(barringServiceType, (Object)barringServiceInfo);
        return this;
    }

    public BarringInfo build() {
        return (BarringInfo)ReflectionHelpers.callConstructor(BarringInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CellIdentity.class, (Object)this.barringCellIdentity), ReflectionHelpers.ClassParameter.from(SparseArray.class, this.barringServiceInfos)});
    }

    private void validateBarringServiceType(int barringServiceType) {
        if (barringServiceType != 0 && barringServiceType != 1 && barringServiceType != 2 && barringServiceType != 3 && barringServiceType != 4 && barringServiceType != 5 && barringServiceType != 6 && barringServiceType != 7 && barringServiceType != 8 && barringServiceType != 9) {
            throw new IllegalArgumentException("Unknown barringServiceType: " + barringServiceType);
        }
    }

    public static class BarringServiceInfoBuilder {
        private int barringType = 0;
        private boolean isConditionallyBarred;
        private int conditionalBarringFactor;
        private int conditionalBarringTimeSeconds;

        private BarringServiceInfoBuilder() {
        }

        public static BarringServiceInfoBuilder newBuilder() {
            return new BarringServiceInfoBuilder();
        }

        @CanIgnoreReturnValue
        public BarringServiceInfoBuilder setBarringType(int barringType) {
            this.validateBarringType(barringType);
            this.barringType = barringType;
            return this;
        }

        @CanIgnoreReturnValue
        public BarringServiceInfoBuilder setIsConditionallyBarred(boolean isConditionallyBarred) {
            this.isConditionallyBarred = isConditionallyBarred;
            return this;
        }

        @CanIgnoreReturnValue
        public BarringServiceInfoBuilder setConditionalBarringFactor(int conditionalBarringFactor) {
            this.conditionalBarringFactor = conditionalBarringFactor;
            return this;
        }

        @CanIgnoreReturnValue
        public BarringServiceInfoBuilder setConditionalBarringTimeSeconds(int conditionalBarringTimeSeconds) {
            this.conditionalBarringTimeSeconds = conditionalBarringTimeSeconds;
            return this;
        }

        public BarringInfo.BarringServiceInfo build() {
            return (BarringInfo.BarringServiceInfo)ReflectionHelpers.callConstructor(BarringInfo.BarringServiceInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.barringType), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isConditionallyBarred), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.conditionalBarringFactor), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.conditionalBarringTimeSeconds)});
        }

        private void validateBarringType(int barringType) {
            if (barringType != 0 && barringType != 2 && barringType != 1 && barringType != -1) {
                throw new IllegalArgumentException("Unknown barringType: " + barringType);
            }
        }
    }
}

