/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.provider.Settings;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=Settings.class)
public class ShadowSettings {
    public static void setAirplaneMode(boolean isAirplaneMode) {
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
    }

    public static void setWifiOn(boolean isOn) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
    }

    public static void set24HourTimeFormat(boolean use24HourTimeFormat) {
        Settings.System.putString((ContentResolver)RuntimeEnvironment.application.getContentResolver(), (String)"time_12_24", (String)(use24HourTimeFormat ? "24" : "12"));
    }

    @Implements(value=Settings.Global.class, inheritImplementationMethods=true, minSdk=17)
    public static class ShadowGlobal
    extends ShadowSystem {
    }

    @Implements(value=Settings.Secure.class, inheritImplementationMethods=true)
    public static class ShadowSecure
    extends ShadowSystem {
    }

    @Implements(value=Settings.System.class)
    public static class ShadowSystem {
        private static final WeakHashMap<ContentResolver, Map<String, Object>> dataMap = new WeakHashMap();

        @Implementation
        public static boolean putInt(ContentResolver cr, String name, int value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static int getInt(ContentResolver cr, String name, int def) {
            if (ShadowSystem.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowSystem.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        public static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Integer) {
                return (Integer)ShadowSystem.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        public static boolean putString(ContentResolver cr, String name, String value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static String getString(ContentResolver cr, String name) {
            if (ShadowSystem.get(cr).get(name) instanceof String) {
                return (String)ShadowSystem.get(cr).get(name);
            }
            return null;
        }

        @Implementation(minSdk=17)
        public static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSystem.getString(cr, name);
        }

        @Implementation
        public static boolean putLong(ContentResolver cr, String name, long value) {
            ShadowSystem.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static long getLong(ContentResolver cr, String name, long def) {
            if (ShadowSystem.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSystem.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        public static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Long) {
                return (Long)ShadowSystem.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        public static boolean putFloat(ContentResolver cr, String name, float value) {
            ShadowSystem.get(cr).put(name, Float.valueOf(value));
            return true;
        }

        @Implementation
        public static float getFloat(ContentResolver cr, String name, float def) {
            if (ShadowSystem.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSystem.get(cr).get(name)).floatValue();
            }
            return def;
        }

        @Implementation
        public static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (ShadowSystem.get(cr).get(name) instanceof Float) {
                return ((Float)ShadowSystem.get(cr).get(name)).floatValue();
            }
            throw new Settings.SettingNotFoundException(name);
        }

        private static Map<String, Object> get(ContentResolver cr) {
            Map<String, Object> map = dataMap.get(cr);
            if (map == null) {
                map = new HashMap<String, Object>();
                dataMap.put(cr, map);
            }
            return map;
        }
    }
}

