/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=Matrix.class)
public class ShadowMatrix {
    public static final String TRANSLATE = "translate";
    public static final String SCALE = "scale";
    public static final String ROTATE = "rotate";
    public static final String SINCOS = "sincos";
    public static final String SKEW = "skew";
    public static final String MATRIX = "matrix";
    private static final float EPSILON = 0.001f;
    private final Deque<String> preOps = new ArrayDeque<String>();
    private final Deque<String> postOps = new ArrayDeque<String>();
    private final Map<String, String> setOps = new LinkedHashMap<String, String>();
    private SimpleMatrix mMatrix = SimpleMatrix.access$000();

    @Implementation
    public void __constructor__(Matrix src) {
        this.set(src);
    }

    public List<String> getPreOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.preOps));
    }

    public List<String> getPostOperations() {
        return Collections.unmodifiableList(new ArrayList<String>(this.postOps));
    }

    public Map<String, String> getSetOperations() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.setOps));
    }

    @Implementation
    public boolean isIdentity() {
        return this.mMatrix.equals(SimpleMatrix.IDENTITY);
    }

    @Implementation
    public boolean isAffine() {
        return this.mMatrix.isAffine();
    }

    @Implementation
    public boolean rectStaysRect() {
        return this.mMatrix.rectStaysRect();
    }

    @Implementation
    public void getValues(float[] values) {
        this.mMatrix.getValues(values);
    }

    @Implementation
    public void setValues(float[] values) {
        this.mMatrix = new SimpleMatrix(values);
    }

    @Implementation
    public void set(Matrix src) {
        this.reset();
        if (src != null) {
            ShadowMatrix shadowMatrix = Shadows.shadowOf(src);
            this.preOps.addAll(shadowMatrix.preOps);
            this.postOps.addAll(shadowMatrix.postOps);
            this.setOps.putAll(shadowMatrix.setOps);
            this.mMatrix = new SimpleMatrix(ShadowMatrix.getSimpleMatrix(src));
        }
    }

    @Implementation
    public void reset() {
        this.preOps.clear();
        this.postOps.clear();
        this.setOps.clear();
        this.mMatrix = SimpleMatrix.IDENTITY;
    }

    @Implementation
    public void setTranslate(float dx, float dy) {
        this.setOps.put(TRANSLATE, dx + " " + dy);
        this.mMatrix = SimpleMatrix.translate(dx, dy);
    }

    @Implementation
    public void setScale(float sx, float sy, float px, float py) {
        this.setOps.put(SCALE, sx + " " + sy + " " + px + " " + py);
        this.mMatrix = SimpleMatrix.scale(sx, sy, px, py);
    }

    @Implementation
    public void setScale(float sx, float sy) {
        this.setOps.put(SCALE, sx + " " + sy);
        this.mMatrix = SimpleMatrix.scale(sx, sy);
    }

    @Implementation
    public void setRotate(float degrees, float px, float py) {
        this.setOps.put(ROTATE, degrees + " " + px + " " + py);
        this.mMatrix = SimpleMatrix.rotate(degrees, px, py);
    }

    @Implementation
    public void setRotate(float degrees) {
        this.setOps.put(ROTATE, Float.toString(degrees));
        this.mMatrix = SimpleMatrix.rotate(degrees);
    }

    @Implementation
    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        this.setOps.put(SINCOS, sinValue + " " + cosValue + " " + px + " " + py);
        this.mMatrix = SimpleMatrix.sinCos(sinValue, cosValue, px, py);
    }

    @Implementation
    public void setSinCos(float sinValue, float cosValue) {
        this.setOps.put(SINCOS, sinValue + " " + cosValue);
        this.mMatrix = SimpleMatrix.sinCos(sinValue, cosValue);
    }

    @Implementation
    public void setSkew(float kx, float ky, float px, float py) {
        this.setOps.put(SKEW, kx + " " + ky + " " + px + " " + py);
        this.mMatrix = SimpleMatrix.skew(kx, ky, px, py);
    }

    @Implementation
    public void setSkew(float kx, float ky) {
        this.setOps.put(SKEW, kx + " " + ky);
        this.mMatrix = SimpleMatrix.skew(kx, ky);
    }

    @Implementation
    public boolean setConcat(Matrix a, Matrix b) {
        this.mMatrix = ShadowMatrix.getSimpleMatrix(a).multiply(ShadowMatrix.getSimpleMatrix(b));
        return true;
    }

    @Implementation
    public boolean preTranslate(float dx, float dy) {
        this.preOps.addFirst("translate " + dx + " " + dy);
        return this.preConcat(SimpleMatrix.translate(dx, dy));
    }

    @Implementation
    public boolean preScale(float sx, float sy, float px, float py) {
        this.preOps.addFirst("scale " + sx + " " + sy + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.scale(sx, sy, px, py));
    }

    @Implementation
    public boolean preScale(float sx, float sy) {
        this.preOps.addFirst("scale " + sx + " " + sy);
        return this.preConcat(SimpleMatrix.scale(sx, sy));
    }

    @Implementation
    public boolean preRotate(float degrees, float px, float py) {
        this.preOps.addFirst("rotate " + degrees + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.rotate(degrees, px, py));
    }

    @Implementation
    public boolean preRotate(float degrees) {
        this.preOps.addFirst("rotate " + Float.toString(degrees));
        return this.preConcat(SimpleMatrix.rotate(degrees));
    }

    @Implementation
    public boolean preSkew(float kx, float ky, float px, float py) {
        this.preOps.addFirst("skew " + kx + " " + ky + " " + px + " " + py);
        return this.preConcat(SimpleMatrix.skew(kx, ky, px, py));
    }

    @Implementation
    public boolean preSkew(float kx, float ky) {
        this.preOps.addFirst("skew " + kx + " " + ky);
        return this.preConcat(SimpleMatrix.skew(kx, ky));
    }

    @Implementation
    public boolean preConcat(Matrix other) {
        this.preOps.addFirst("matrix " + other);
        return this.preConcat(ShadowMatrix.getSimpleMatrix(other));
    }

    @Implementation
    public boolean postTranslate(float dx, float dy) {
        this.postOps.addLast("translate " + dx + " " + dy);
        return this.postConcat(SimpleMatrix.translate(dx, dy));
    }

    @Implementation
    public boolean postScale(float sx, float sy, float px, float py) {
        this.postOps.addLast("scale " + sx + " " + sy + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.scale(sx, sy, px, py));
    }

    @Implementation
    public boolean postScale(float sx, float sy) {
        this.postOps.addLast("scale " + sx + " " + sy);
        return this.postConcat(SimpleMatrix.scale(sx, sy));
    }

    @Implementation
    public boolean postRotate(float degrees, float px, float py) {
        this.postOps.addLast("rotate " + degrees + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.rotate(degrees, px, py));
    }

    @Implementation
    public boolean postRotate(float degrees) {
        this.postOps.addLast("rotate " + Float.toString(degrees));
        return this.postConcat(SimpleMatrix.rotate(degrees));
    }

    @Implementation
    public boolean postSkew(float kx, float ky, float px, float py) {
        this.postOps.addLast("skew " + kx + " " + ky + " " + px + " " + py);
        return this.postConcat(SimpleMatrix.skew(kx, ky, px, py));
    }

    @Implementation
    public boolean postSkew(float kx, float ky) {
        this.postOps.addLast("skew " + kx + " " + ky);
        return this.postConcat(SimpleMatrix.skew(kx, ky));
    }

    @Implementation
    public boolean postConcat(Matrix other) {
        this.postOps.addLast("matrix " + other);
        return this.postConcat(ShadowMatrix.getSimpleMatrix(other));
    }

    @Implementation
    public boolean invert(Matrix inverse) {
        SimpleMatrix inverseMatrix = this.mMatrix.invert();
        if (inverseMatrix != null) {
            if (inverse != null) {
                ShadowMatrix shadowInverse = (ShadowMatrix)Shadow.extract((Object)inverse);
                shadowInverse.mMatrix = inverseMatrix;
            }
            return true;
        }
        return false;
    }

    public PointF mapPoint(float x, float y) {
        return this.mMatrix.transform(new PointF(x, y));
    }

    public PointF mapPoint(PointF point) {
        return this.mMatrix.transform(point);
    }

    @Implementation
    public boolean mapRect(RectF destination, RectF source) {
        PointF leftTop = this.mapPoint(source.left, source.top);
        PointF rightBottom = this.mapPoint(source.right, source.bottom);
        destination.set(Math.min(leftTop.x, rightBottom.x), Math.min(leftTop.y, rightBottom.y), Math.max(leftTop.x, rightBottom.x), Math.max(leftTop.y, rightBottom.y));
        return true;
    }

    @Implementation
    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return ShadowMatrix.getSimpleMatrix((Matrix)obj).equals(this.mMatrix);
        }
        return obj instanceof ShadowMatrix && obj.equals(this.mMatrix);
    }

    @Implementation
    public int hashCode() {
        return Objects.hashCode(this.mMatrix);
    }

    public String getDescription() {
        return "Matrix[pre=" + this.preOps + ", set=" + this.setOps + ", post=" + this.postOps + "]";
    }

    private static SimpleMatrix getSimpleMatrix(Matrix matrix) {
        ShadowMatrix otherMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        return otherMatrix.mMatrix;
    }

    private boolean postConcat(SimpleMatrix matrix) {
        this.mMatrix = matrix.multiply(this.mMatrix);
        return true;
    }

    private boolean preConcat(SimpleMatrix matrix) {
        this.mMatrix = this.mMatrix.multiply(matrix);
        return true;
    }

    private static class SimpleMatrix {
        private static final SimpleMatrix IDENTITY = new SimpleMatrix(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        private final float[] mValues;

        SimpleMatrix(SimpleMatrix matrix) {
            this.mValues = Arrays.copyOf(matrix.mValues, matrix.mValues.length);
        }

        private SimpleMatrix(float[] values) {
            if (values.length != 9) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mValues = Arrays.copyOf(values, 9);
        }

        public boolean isAffine() {
            return this.mValues[6] == 0.0f && this.mValues[7] == 0.0f && this.mValues[8] == 1.0f;
        }

        public boolean rectStaysRect() {
            float m00 = this.mValues[0];
            float m01 = this.mValues[1];
            float m10 = this.mValues[3];
            float m11 = this.mValues[4];
            return m00 == 0.0f && m11 == 0.0f && m01 != 0.0f && m10 != 0.0f || m00 != 0.0f && m11 != 0.0f && m01 == 0.0f && m10 == 0.0f;
        }

        public void getValues(float[] values) {
            if (values.length < 9) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(this.mValues, 0, values, 0, 9);
        }

        public static SimpleMatrix translate(float dx, float dy) {
            return new SimpleMatrix(new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix scale(float sx, float sy, float px, float py) {
            return new SimpleMatrix(new float[]{sx, 0.0f, px * (1.0f - sx), 0.0f, sy, py * (1.0f - sy), 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix scale(float sx, float sy) {
            return new SimpleMatrix(new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix rotate(float degrees, float px, float py) {
            double radians = Math.toRadians(degrees);
            float sin = (float)Math.sin(radians);
            float cos = (float)Math.cos(radians);
            return SimpleMatrix.sinCos(sin, cos, px, py);
        }

        public static SimpleMatrix rotate(float degrees) {
            double radians = Math.toRadians(degrees);
            float sin = (float)Math.sin(radians);
            float cos = (float)Math.cos(radians);
            return SimpleMatrix.sinCos(sin, cos);
        }

        public static SimpleMatrix sinCos(float sin, float cos, float px, float py) {
            return new SimpleMatrix(new float[]{cos, -sin, sin * py + (1.0f - cos) * px, sin, cos, -sin * px + (1.0f - cos) * py, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix sinCos(float sin, float cos) {
            return new SimpleMatrix(new float[]{cos, -sin, 0.0f, sin, cos, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix skew(float kx, float ky, float px, float py) {
            return new SimpleMatrix(new float[]{1.0f, kx, -kx * py, ky, 1.0f, -ky * px, 0.0f, 0.0f, 1.0f});
        }

        public static SimpleMatrix skew(float kx, float ky) {
            return new SimpleMatrix(new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        }

        public SimpleMatrix multiply(SimpleMatrix matrix) {
            float[] values = new float[9];
            for (int i = 0; i < values.length; ++i) {
                int row = i / 3;
                int col = i % 3;
                for (int j = 0; j < 3; ++j) {
                    int n = i;
                    values[n] = values[n] + this.mValues[row * 3 + j] * matrix.mValues[j * 3 + col];
                }
            }
            return new SimpleMatrix(values);
        }

        public SimpleMatrix invert() {
            float invDet = this.inverseDeterminant();
            if (invDet == 0.0f) {
                return null;
            }
            float[] src = this.mValues;
            float[] dst = new float[]{SimpleMatrix.cross_scale(src[4], src[8], src[5], src[7], invDet), SimpleMatrix.cross_scale(src[2], src[7], src[1], src[8], invDet), SimpleMatrix.cross_scale(src[1], src[5], src[2], src[4], invDet), SimpleMatrix.cross_scale(src[5], src[6], src[3], src[8], invDet), SimpleMatrix.cross_scale(src[0], src[8], src[2], src[6], invDet), SimpleMatrix.cross_scale(src[2], src[3], src[0], src[5], invDet), SimpleMatrix.cross_scale(src[3], src[7], src[4], src[6], invDet), SimpleMatrix.cross_scale(src[1], src[6], src[0], src[7], invDet), SimpleMatrix.cross_scale(src[0], src[4], src[1], src[3], invDet)};
            return new SimpleMatrix(dst);
        }

        public PointF transform(PointF point) {
            return new PointF(point.x * this.mValues[0] + point.y * this.mValues[1] + this.mValues[2], point.x * this.mValues[3] + point.y * this.mValues[4] + this.mValues[5]);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof SimpleMatrix && this.equals((SimpleMatrix)o);
        }

        public boolean equals(SimpleMatrix matrix) {
            if (matrix == null) {
                return false;
            }
            for (int i = 0; i < this.mValues.length; ++i) {
                if (SimpleMatrix.isNearlyZero(matrix.mValues[i] - this.mValues[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.mValues);
        }

        private static boolean isNearlyZero(float value) {
            return Math.abs(value) < 0.001f;
        }

        private static float cross(float a, float b, float c, float d) {
            return a * b - c * d;
        }

        private static float cross_scale(float a, float b, float c, float d, float scale) {
            return SimpleMatrix.cross(a, b, c, d) * scale;
        }

        private float inverseDeterminant() {
            float determinant = this.mValues[0] * SimpleMatrix.cross(this.mValues[4], this.mValues[8], this.mValues[5], this.mValues[7]) + this.mValues[1] * SimpleMatrix.cross(this.mValues[5], this.mValues[6], this.mValues[3], this.mValues[8]) + this.mValues[2] * SimpleMatrix.cross(this.mValues[3], this.mValues[7], this.mValues[4], this.mValues[6]);
            return SimpleMatrix.isNearlyZero(determinant) ? 0.0f : 1.0f / determinant;
        }
    }
}

