/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.UriPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.BaseCursor;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.NamedStream;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ContentResolver.class)
public class ShadowContentResolver {
    private int nextDatabaseIdForInserts;
    private int nextDatabaseIdForUpdates = -1;
    @RealObject
    ContentResolver realContentResolver;
    private BaseCursor cursor;
    private final List<Statement> statements = new ArrayList<Statement>();
    private final List<InsertStatement> insertStatements = new ArrayList<InsertStatement>();
    private final List<UpdateStatement> updateStatements = new ArrayList<UpdateStatement>();
    private final List<DeleteStatement> deleteStatements = new ArrayList<DeleteStatement>();
    private List<NotifiedUri> notifiedUris = new ArrayList<NotifiedUri>();
    private Map<Uri, BaseCursor> uriCursorMap = new HashMap<Uri, BaseCursor>();
    private Map<Uri, InputStream> inputStreamMap = new HashMap<Uri, InputStream>();
    private final Map<String, List<ContentProviderOperation>> contentProviderOperations = new HashMap<String, List<ContentProviderOperation>>();
    private ContentProviderResult[] contentProviderResults;
    private final List<UriPermission> uriPermissions = new ArrayList<UriPermission>();
    private final CopyOnWriteArrayList<ContentObserverEntry> contentObservers = new CopyOnWriteArrayList();
    private static final Map<String, Map<Account, Status>> syncableAccounts = new HashMap<String, Map<Account, Status>>();
    private static final Map<String, ContentProvider> providers = new HashMap<String, ContentProvider>();
    private static boolean masterSyncAutomatically;

    @Resetter
    public static synchronized void reset() {
        syncableAccounts.clear();
        providers.clear();
        masterSyncAutomatically = false;
    }

    public void registerInputStream(Uri uri, InputStream inputStream) {
        this.inputStreamMap.put(uri, inputStream);
    }

    @Implementation
    public final InputStream openInputStream(Uri uri) {
        InputStream inputStream = this.inputStreamMap.get(uri);
        if (inputStream != null) {
            return inputStream;
        }
        return new UnregisteredInputStream(uri);
    }

    @Implementation
    public final OutputStream openOutputStream(final Uri uri) {
        return new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }

            public String toString() {
                return "outputstream for " + uri;
            }
        };
    }

    @Implementation
    public final Uri insert(Uri url, ContentValues values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        ContentValues valuesCopy = values == null ? null : new ContentValues(values);
        InsertStatement insertStatement = new InsertStatement(url, provider, valuesCopy);
        this.statements.add(insertStatement);
        this.insertStatements.add(insertStatement);
        if (provider != null) {
            return provider.insert(url, values);
        }
        return Uri.parse((String)(url.toString() + "/" + ++this.nextDatabaseIdForInserts));
    }

    @Implementation
    public int update(Uri uri, ContentValues values, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        ContentValues valuesCopy = values == null ? null : new ContentValues(values);
        UpdateStatement updateStatement = new UpdateStatement(uri, provider, valuesCopy, where, selectionArgs);
        this.statements.add(updateStatement);
        this.updateStatements.add(updateStatement);
        if (provider != null) {
            return provider.update(uri, values, where, selectionArgs);
        }
        return this.nextDatabaseIdForUpdates == -1 ? 1 : (this.nextDatabaseIdForUpdates = this.nextDatabaseIdForUpdates + 1);
    }

    @Implementation
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
        }
        BaseCursor returnCursor = this.getCursor(uri);
        if (returnCursor == null) {
            return null;
        }
        returnCursor.setQuery(uri, projection, selection, selectionArgs, sortOrder);
        return returnCursor;
    }

    @Implementation
    public String getType(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider != null) {
            return provider.getType(uri);
        }
        return null;
    }

    @Implementation
    public Bundle call(Uri uri, String method, String arg, Bundle extras) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri);
        if (cp != null) {
            return cp.call(method, arg, extras);
        }
        return null;
    }

    @Implementation
    public final ContentProviderClient acquireContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    public final ContentProviderClient acquireContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, true);
    }

    @Implementation
    public final ContentProviderClient acquireUnstableContentProviderClient(String name) {
        ContentProvider provider = ShadowContentResolver.getProvider(name);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    @Implementation
    public final ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider == null) {
            return null;
        }
        return this.getContentProviderClient(provider, false);
    }

    private ContentProviderClient getContentProviderClient(ContentProvider provider, boolean stable) {
        ContentProviderClient client = (ContentProviderClient)Shadow.newInstance(ContentProviderClient.class, (Class[])new Class[]{ContentResolver.class, IContentProvider.class, Boolean.TYPE}, (Object[])new Object[]{this.realContentResolver, provider.getIContentProvider(), stable});
        Shadows.shadowOf(client).setContentProvider(provider);
        return client;
    }

    @Implementation
    public final IContentProvider acquireProvider(String name) {
        return this.acquireUnstableProvider(name);
    }

    @Implementation
    public final IContentProvider acquireProvider(Uri uri) {
        return this.acquireUnstableProvider(uri);
    }

    @Implementation
    public final IContentProvider acquireUnstableProvider(String name) {
        ContentProvider cp = ShadowContentResolver.getProvider(name);
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    public final IContentProvider acquireUnstableProvider(Uri uri) {
        ContentProvider cp = ShadowContentResolver.getProvider(uri);
        if (cp != null) {
            return cp.getIContentProvider();
        }
        return null;
    }

    @Implementation
    public final int delete(Uri url, String where, String[] selectionArgs) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        DeleteStatement deleteStatement = new DeleteStatement(url, provider, where, selectionArgs);
        this.statements.add(deleteStatement);
        this.deleteStatements.add(deleteStatement);
        if (provider != null) {
            return provider.delete(url, where, selectionArgs);
        }
        return 1;
    }

    @Implementation
    public final int bulkInsert(Uri url, ContentValues[] values) {
        ContentProvider provider = ShadowContentResolver.getProvider(url);
        InsertStatement insertStatement = new InsertStatement(url, provider, values);
        this.statements.add(insertStatement);
        this.insertStatements.add(insertStatement);
        if (provider != null) {
            return provider.bulkInsert(url, values);
        }
        return values.length;
    }

    @Implementation
    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
        this.notifiedUris.add(new NotifiedUri(uri, observer, syncToNetwork));
        for (ContentObserverEntry entry : this.contentObservers) {
            if (!entry.matches(uri) || entry.observer == observer) continue;
            entry.observer.dispatchChange(false, uri);
        }
        if (observer != null && observer.deliverSelfNotifications()) {
            observer.dispatchChange(true, uri);
        }
    }

    @Implementation
    public void notifyChange(Uri uri, ContentObserver observer) {
        this.notifyChange(uri, observer, false);
    }

    @Implementation
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        ContentProvider provider = ShadowContentResolver.getProvider(authority);
        if (provider != null) {
            return provider.applyBatch(operations);
        }
        this.contentProviderOperations.put(authority, operations);
        return this.contentProviderResults;
    }

    @Implementation
    public static void requestSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority, true);
        ++status.syncRequests;
        status.syncExtras = extras;
    }

    @Implementation
    public static void cancelSync(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            status.syncRequests = 0;
            if (status.syncExtras != null) {
                status.syncExtras.clear();
            }
            if (status.syncs != null) {
                status.syncs.clear();
            }
        }
    }

    @Implementation
    public static boolean isSyncActive(Account account, String authority) {
        Status status = ShadowContentResolver.getStatus(account, authority);
        return status != null && status.syncRequests > 0;
    }

    @Implementation
    public static void setIsSyncable(Account account, String authority, int syncable) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state = syncable;
    }

    @Implementation
    public static int getIsSyncable(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).state;
    }

    @Implementation
    public static boolean getSyncAutomatically(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically;
    }

    @Implementation
    public static void setSyncAutomatically(Account account, String authority, boolean sync) {
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncAutomatically = sync;
    }

    @Implementation
    public static void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        ShadowContentResolver.removePeriodicSync(account, authority, extras);
        ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs.add(new PeriodicSync(account, authority, extras, pollFrequency));
    }

    @Implementation
    public static void removePeriodicSync(Account account, String authority, Bundle extras) {
        ShadowContentResolver.validateSyncExtrasBundle(extras);
        Status status = ShadowContentResolver.getStatus(account, authority);
        if (status != null) {
            for (int i = 0; i < status.syncs.size(); ++i) {
                if (!ShadowContentResolver.isBundleEqual(extras, status.syncs.get((int)i).extras)) continue;
                status.syncs.remove(i);
                break;
            }
        }
    }

    @Implementation
    public static List<PeriodicSync> getPeriodicSyncs(Account account, String authority) {
        return ShadowContentResolver.getStatus((Account)account, (String)authority, (boolean)true).syncs;
    }

    @Implementation
    public static void validateSyncExtrasBundle(Bundle extras) {
        for (String key : extras.keySet()) {
            Object value = extras.get(key);
            if (value == null || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Account) continue;
            throw new IllegalArgumentException("unexpected value type: " + value.getClass().getName());
        }
    }

    @Implementation
    public static void setMasterSyncAutomatically(boolean sync) {
        masterSyncAutomatically = sync;
    }

    @Implementation
    public static boolean getMasterSyncAutomatically() {
        return masterSyncAutomatically;
    }

    @Implementation(minSdk=19)
    public void takePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri may not be null");
        if ((modeFlags &= 3) == 0) {
            return;
        }
        Iterator<UriPermission> i = this.uriPermissions.iterator();
        while (i.hasNext()) {
            UriPermission perm = i.next();
            if (!uri.equals((Object)perm.getUri())) continue;
            if (perm.isReadPermission()) {
                modeFlags |= 1;
            }
            if (perm.isWritePermission()) {
                modeFlags |= 2;
            }
            i.remove();
            break;
        }
        this.addUriPermission(uri, modeFlags);
    }

    @Implementation(minSdk=19)
    public void releasePersistableUriPermission(Uri uri, int modeFlags) {
        Objects.requireNonNull(uri, "uri may not be null");
        if ((modeFlags &= 3) == 0) {
            return;
        }
        Iterator<UriPermission> i = this.uriPermissions.iterator();
        while (i.hasNext()) {
            UriPermission perm = i.next();
            if (!uri.equals((Object)perm.getUri())) continue;
            int oldModeFlags = (perm.isReadPermission() ? 1 : 0) | (perm.isWritePermission() ? 2 : 0);
            int newModeFlags = oldModeFlags & ~modeFlags;
            if (newModeFlags == oldModeFlags) break;
            i.remove();
            if (newModeFlags == 0) break;
            this.addUriPermission(uri, newModeFlags);
            break;
        }
    }

    @Implementation(minSdk=19)
    public List<UriPermission> getPersistedUriPermissions() {
        return this.uriPermissions;
    }

    private void addUriPermission(Uri uri, int modeFlags) {
        ReflectionHelpers.ClassParameter p1 = new ReflectionHelpers.ClassParameter(Uri.class, (Object)uri);
        ReflectionHelpers.ClassParameter p2 = new ReflectionHelpers.ClassParameter(Integer.TYPE, (Object)modeFlags);
        ReflectionHelpers.ClassParameter p3 = new ReflectionHelpers.ClassParameter(Long.TYPE, (Object)System.currentTimeMillis());
        UriPermission perm = (UriPermission)ReflectionHelpers.callConstructor(UriPermission.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{p1, p2, p3});
        this.uriPermissions.add(perm);
    }

    public static ContentProvider getProvider(Uri uri) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return null;
        }
        return ShadowContentResolver.getProvider(uri.getAuthority());
    }

    private static synchronized ContentProvider getProvider(String authority) {
        AndroidManifest manifest;
        if (!providers.containsKey(authority) && (manifest = Shadows.shadowOf(RuntimeEnvironment.application).getAppManifest()) != null) {
            for (ContentProviderData providerData : manifest.getContentProviders()) {
                if (!providerData.getAuthorities().equals(authority)) continue;
                providers.put(providerData.getAuthorities(), ShadowContentResolver.createAndInitialize(providerData));
            }
        }
        return providers.get(authority);
    }

    public static synchronized void registerProviderInternal(String authority, ContentProvider provider) {
        providers.put(authority, provider);
    }

    public static Status getStatus(Account account, String authority) {
        return ShadowContentResolver.getStatus(account, authority, false);
    }

    public static Status getStatus(Account account, String authority, boolean create) {
        Status status;
        Map<Account, Status> map = syncableAccounts.get(authority);
        if (map == null) {
            map = new HashMap<Account, Status>();
            syncableAccounts.put(authority, map);
        }
        if ((status = map.get(account)) == null && create) {
            status = new Status();
            map.put(account, status);
        }
        return status;
    }

    public void setCursor(BaseCursor cursor) {
        this.cursor = cursor;
    }

    public void setCursor(Uri uri, BaseCursor cursorForUri) {
        this.uriCursorMap.put(uri, cursorForUri);
    }

    public void setNextDatabaseIdForInserts(int nextId) {
        this.nextDatabaseIdForInserts = nextId;
    }

    @Deprecated
    public void setNextDatabaseIdForUpdates(int nextId) {
        this.nextDatabaseIdForUpdates = nextId;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<InsertStatement> getInsertStatements() {
        return this.insertStatements;
    }

    public List<UpdateStatement> getUpdateStatements() {
        return this.updateStatements;
    }

    public List<Uri> getDeletedUris() {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (DeleteStatement deleteStatement : this.deleteStatements) {
            uris.add(deleteStatement.getUri());
        }
        return uris;
    }

    public List<DeleteStatement> getDeleteStatements() {
        return this.deleteStatements;
    }

    public List<NotifiedUri> getNotifiedUris() {
        return this.notifiedUris;
    }

    public List<ContentProviderOperation> getContentProviderOperations(String authority) {
        List<ContentProviderOperation> operations = this.contentProviderOperations.get(authority);
        if (operations == null) {
            return new ArrayList<ContentProviderOperation>();
        }
        return operations;
    }

    public void setContentProviderResult(ContentProviderResult[] contentProviderResults) {
        this.contentProviderResults = contentProviderResults;
    }

    @Implementation
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
        if (uri == null || observer == null) {
            throw new NullPointerException();
        }
        this.contentObservers.add(new ContentObserverEntry(uri, notifyForDescendents, observer));
    }

    @Implementation
    public void registerContentObserver(Uri uri, boolean notifyForDescendents, ContentObserver observer, int userHandle) {
        this.registerContentObserver(uri, notifyForDescendents, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public void unregisterContentObserver(ContentObserver observer) {
        CopyOnWriteArrayList<ContentObserverEntry> copyOnWriteArrayList = this.contentObservers;
        synchronized (copyOnWriteArrayList) {
            for (ContentObserverEntry entry : this.contentObservers) {
                if (entry.observer != observer) continue;
                this.contentObservers.remove(entry);
            }
        }
    }

    @Deprecated
    public void clearContentObservers() {
        this.contentObservers.clear();
    }

    public Collection<ContentObserver> getContentObservers(Uri uri) {
        ArrayList<ContentObserver> observers = new ArrayList<ContentObserver>(1);
        for (ContentObserverEntry entry : this.contentObservers) {
            if (!entry.matches(uri)) continue;
            observers.add(entry.observer);
        }
        return observers;
    }

    @Implementation
    public final AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String mimeType, Bundle opts) throws FileNotFoundException {
        ContentProvider provider = ShadowContentResolver.getProvider(uri);
        if (provider == null) {
            return null;
        }
        return provider.openTypedAssetFile(uri, mimeType, opts);
    }

    private static ContentProvider createAndInitialize(ContentProviderData providerData) {
        try {
            ContentProvider provider = (ContentProvider)Class.forName(providerData.getClassName()).newInstance();
            ShadowContentResolver.initialize(provider, providerData.getAuthorities());
            return provider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating class " + providerData.getClassName());
        }
    }

    private static void initialize(ContentProvider provider, String authorities) {
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.authority = authorities;
        providerInfo.grantUriPermissions = true;
        provider.attachInfo((Context)RuntimeEnvironment.application, providerInfo);
        provider.onCreate();
    }

    private BaseCursor getCursor(Uri uri) {
        if (this.uriCursorMap.get(uri) != null) {
            return this.uriCursorMap.get(uri);
        }
        if (this.cursor != null) {
            return this.cursor;
        }
        return null;
    }

    private static boolean isBundleEqual(Bundle bundle1, Bundle bundle2) {
        if (bundle1 == null || bundle2 == null) {
            return false;
        }
        if (bundle1.size() != bundle2.size()) {
            return false;
        }
        for (String key : bundle1.keySet()) {
            if (bundle1.get(key).equals(bundle2.get(key))) continue;
            return false;
        }
        return true;
    }

    private static class UnregisteredInputStream
    extends InputStream
    implements NamedStream {
        private final Uri uri;

        UnregisteredInputStream(Uri uri) {
            this.uri = uri;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("You must use ShadowContentResolver.registerInputStream() in order to call read()");
        }

        public String toString() {
            return "stream for " + this.uri;
        }
    }

    public static class DeleteStatement
    extends Statement {
        private final String where;
        private final String[] selectionArgs;

        DeleteStatement(Uri uri, ContentProvider contentProvider, String where, String[] selectionArgs) {
            super(uri, contentProvider);
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class UpdateStatement
    extends Statement {
        private final ContentValues values;
        private final String where;
        private final String[] selectionArgs;

        UpdateStatement(Uri uri, ContentProvider contentProvider, ContentValues values, String where, String[] selectionArgs) {
            super(uri, contentProvider);
            this.values = values;
            this.where = where;
            this.selectionArgs = selectionArgs;
        }

        public ContentValues getContentValues() {
            return this.values;
        }

        public String getWhere() {
            return this.where;
        }

        public String[] getSelectionArgs() {
            return this.selectionArgs;
        }
    }

    public static class InsertStatement
    extends Statement {
        private final ContentValues[] bulkContentValues;

        InsertStatement(Uri uri, ContentProvider contentProvider, ContentValues contentValues) {
            super(uri, contentProvider);
            this.bulkContentValues = new ContentValues[]{contentValues};
        }

        InsertStatement(Uri uri, ContentProvider contentProvider, ContentValues[] bulkContentValues) {
            super(uri, contentProvider);
            this.bulkContentValues = bulkContentValues;
        }

        public ContentValues getContentValues() {
            if (this.bulkContentValues.length != 1) {
                throw new ArrayIndexOutOfBoundsException("bulk insert, use getBulkContentValues() instead");
            }
            return this.bulkContentValues[0];
        }

        public ContentValues[] getBulkContentValues() {
            return this.bulkContentValues;
        }
    }

    public static class Statement {
        private final Uri uri;
        private final ContentProvider contentProvider;

        Statement(Uri uri, ContentProvider contentProvider) {
            this.uri = uri;
            this.contentProvider = contentProvider;
        }

        public Uri getUri() {
            return this.uri;
        }

        public ContentProvider getContentProvider() {
            return this.contentProvider;
        }
    }

    public static class Status {
        public int syncRequests;
        public int state = -1;
        public boolean syncAutomatically;
        public Bundle syncExtras;
        public List<PeriodicSync> syncs = new ArrayList<PeriodicSync>();
    }

    public static class NotifiedUri {
        public final Uri uri;
        public final boolean syncToNetwork;
        public final ContentObserver observer;

        public NotifiedUri(Uri uri, ContentObserver observer, boolean syncToNetwork) {
            this.uri = uri;
            this.syncToNetwork = syncToNetwork;
            this.observer = observer;
        }
    }

    private static class ContentObserverEntry {
        public final Uri uri;
        public final boolean notifyForDescendents;
        public final ContentObserver observer;

        private ContentObserverEntry(Uri uri, boolean notifyForDescendents, ContentObserver observer) {
            this.uri = uri;
            this.notifyForDescendents = notifyForDescendents;
            this.observer = observer;
            if (uri == null || observer == null) {
                throw new NullPointerException();
            }
        }

        public boolean matches(Uri test) {
            String testPath;
            if (!Objects.equals(this.uri.getScheme(), test.getScheme())) {
                return false;
            }
            if (!Objects.equals(this.uri.getAuthority(), test.getAuthority())) {
                return false;
            }
            String uriPath = this.uri.getPath();
            return Objects.equals(uriPath, testPath = test.getPath()) || this.notifyForDescendents && testPath != null && testPath.startsWith(uriPath);
        }
    }
}

