/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowViewGroup;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AdapterView.class)
public class ShadowAdapterView<T extends Adapter>
extends ShadowViewGroup {
    private static int ignoreRowsAtEndOfList = 0;
    @RealObject
    private AdapterView<T> realAdapterView;
    private AdapterView.OnItemSelectedListener itemSelectedListener;

    @Implementation
    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener itemSelectedListener) {
        this.itemSelectedListener = itemSelectedListener;
        Shadow.directlyOn(this.realAdapterView, AdapterView.class, (String)"setOnItemSelectedListener", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(AdapterView.OnItemSelectedListener.class, (Object)itemSelectedListener)});
    }

    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return this.itemSelectedListener;
    }

    public boolean performItemClick(int position) {
        return this.realAdapterView.performItemClick(this.realAdapterView.getChildAt(position), position, this.realAdapterView.getItemIdAtPosition(position));
    }

    public int findIndexOfItemContainingText(String targetText) {
        for (int i = 0; i < this.realAdapterView.getCount(); ++i) {
            View childView = this.realAdapterView.getAdapter().getView(i, null, (ViewGroup)new FrameLayout(this.realAdapterView.getContext()));
            String innerText = Shadows.shadowOf(childView).innerText();
            if (!innerText.contains(targetText)) continue;
            return i;
        }
        return -1;
    }

    public View findItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            return null;
        }
        return this.realAdapterView.getChildAt(itemIndex);
    }

    public void clickFirstItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            throw new IllegalArgumentException("No item found containing text \"" + targetText + "\"");
        }
        this.performItemClick(itemIndex);
    }

    public void populateItems() {
        this.realView.measure(0, 0);
        this.realView.layout(0, 0, 100, 10000);
    }

    public void selectItemWithText(String s) {
        int itemIndex = this.findIndexOfItemContainingText(s);
        this.realAdapterView.setSelection(itemIndex);
    }
}

