/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    private static boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getImageSizeFromStream(InputStream is) {
        if (!initialized) {
            ImageIO.setUseCache(false);
            initialized = true;
        }
        ImageInputStream imageStream = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        try {
            reader.setInput(imageStream);
            Point point = new Point(reader.getWidth(0), reader.getHeight(0));
            reader.dispose();
            return point;
        }
        catch (Throwable throwable) {
            try {
                reader.dispose();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

