/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Parcel;
import android.util.DisplayMetrics;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Bitmap.class)
public class ShadowBitmap {
    private static final int INTERNAL_BYTES_PER_PIXEL = 4;
    @RealObject
    private Bitmap realBitmap;
    int createdFromResId = -1;
    String createdFromPath;
    InputStream createdFromStream;
    FileDescriptor createdFromFileDescriptor;
    byte[] createdFromBytes;
    private Bitmap createdFromBitmap;
    private int createdFromX = -1;
    private int createdFromY = -1;
    private int createdFromWidth = -1;
    private int createdFromHeight = -1;
    private int[] createdFromColors;
    private Matrix createdFromMatrix;
    private boolean createdFromFilter;
    private boolean hasAlpha;
    private int width;
    private int height;
    private int density;
    private int[] colors;
    private Bitmap.Config config;
    private boolean mutable;
    private String description = "";
    private boolean recycled = false;
    private boolean hasMipMap;

    public static String visualize(Bitmap bitmap) {
        return Shadows.shadowOf(bitmap).getDescription();
    }

    public Bitmap getCreatedFromBitmap() {
        return this.createdFromBitmap;
    }

    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    public String getCreatedFromPath() {
        return this.createdFromPath;
    }

    public InputStream getCreatedFromStream() {
        return this.createdFromStream;
    }

    public byte[] getCreatedFromBytes() {
        return this.createdFromBytes;
    }

    public int getCreatedFromX() {
        return this.createdFromX;
    }

    public int getCreatedFromY() {
        return this.createdFromY;
    }

    public int getCreatedFromWidth() {
        return this.createdFromWidth;
    }

    public int getCreatedFromHeight() {
        return this.createdFromHeight;
    }

    public int[] getCreatedFromColors() {
        return this.createdFromColors;
    }

    public Matrix getCreatedFromMatrix() {
        return this.createdFromMatrix;
    }

    public boolean getCreatedFromFilter() {
        return this.createdFromFilter;
    }

    @Implementation
    public boolean compress(Bitmap.CompressFormat format, int quality, OutputStream stream) {
        try {
            stream.write((this.description + " compressed as " + format + " with quality " + quality).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Implementation
    public static Bitmap createBitmap(int width, int height, Bitmap.Config config) {
        return ShadowBitmap.createBitmap((DisplayMetrics)null, width, height, config);
    }

    @Implementation
    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int width, int height, Bitmap.Config config, boolean hasAlpha) {
        return ShadowBitmap.createBitmap((DisplayMetrics)null, width, height, config);
    }

    @Implementation
    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int width, int height, Bitmap.Config config) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap scaledBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(scaledBitmap);
        shadowBitmap.setDescription("Bitmap (" + width + " x " + height + ")");
        shadowBitmap.width = width;
        shadowBitmap.height = height;
        shadowBitmap.config = config;
        shadowBitmap.setMutable(true);
        if (displayMetrics != null) {
            shadowBitmap.density = displayMetrics.densityDpi;
        }
        shadowBitmap.setPixels(new int[shadowBitmap.getHeight() * shadowBitmap.getWidth()], 0, shadowBitmap.getWidth(), 0, 0, shadowBitmap.getWidth(), shadowBitmap.getHeight());
        return scaledBitmap;
    }

    @Implementation
    public static Bitmap createBitmap(Bitmap src) {
        ShadowBitmap shadowBitmap = Shadows.shadowOf(src);
        shadowBitmap.appendDescription(" created from Bitmap object");
        return src;
    }

    @Implementation
    public static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        if (dstWidth == src.getWidth() && dstHeight == src.getHeight() && !filter) {
            return src;
        }
        Bitmap scaledBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(scaledBitmap);
        shadowBitmap.appendDescription(Shadows.shadowOf(src).getDescription());
        shadowBitmap.appendDescription(" scaled to " + dstWidth + " x " + dstHeight);
        if (filter) {
            shadowBitmap.appendDescription(" with filter " + filter);
        }
        shadowBitmap.createdFromBitmap = src;
        shadowBitmap.createdFromFilter = filter;
        shadowBitmap.width = dstWidth;
        shadowBitmap.height = dstHeight;
        shadowBitmap.setPixels(new int[shadowBitmap.getHeight() * shadowBitmap.getWidth()], 0, 0, 0, 0, shadowBitmap.getWidth(), shadowBitmap.getHeight());
        return scaledBitmap;
    }

    @Implementation
    public static Bitmap createBitmap(Bitmap src, int x, int y, int width, int height) {
        if (x == 0 && y == 0 && width == src.getWidth() && height == src.getHeight()) {
            return src;
        }
        Bitmap newBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(newBitmap);
        shadowBitmap.appendDescription(Shadows.shadowOf(src).getDescription());
        shadowBitmap.appendDescription(" at (" + x + "," + y);
        shadowBitmap.appendDescription(" with width " + width + " and height " + height);
        shadowBitmap.createdFromBitmap = src;
        shadowBitmap.createdFromX = x;
        shadowBitmap.createdFromY = y;
        shadowBitmap.createdFromWidth = width;
        shadowBitmap.createdFromHeight = height;
        shadowBitmap.width = width;
        shadowBitmap.height = height;
        return newBitmap;
    }

    @Implementation
    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.colors = pixels;
    }

    @Implementation
    public static Bitmap createBitmap(Bitmap src, int x, int y, int width, int height, Matrix matrix, boolean filter) {
        if (x == 0 && y == 0 && width == src.getWidth() && height == src.getHeight() && (matrix == null || matrix.isIdentity())) {
            return src;
        }
        if (x + width > src.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > src.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        Bitmap newBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(newBitmap);
        shadowBitmap.appendDescription(Shadows.shadowOf(src).getDescription());
        shadowBitmap.appendDescription(" at (" + x + "," + y + ")");
        shadowBitmap.appendDescription(" with width " + width + " and height " + height);
        if (matrix != null) {
            shadowBitmap.appendDescription(" using matrix " + Shadows.shadowOf(matrix).getDescription());
            RectF mappedRect = new RectF();
            matrix.mapRect(mappedRect, new RectF(0.0f, 0.0f, (float)width, (float)height));
            width = Math.round(mappedRect.width());
            height = Math.round(mappedRect.height());
        }
        if (filter) {
            shadowBitmap.appendDescription(" with filter");
        }
        shadowBitmap.createdFromBitmap = src;
        shadowBitmap.createdFromX = x;
        shadowBitmap.createdFromY = y;
        shadowBitmap.createdFromWidth = width;
        shadowBitmap.createdFromHeight = height;
        shadowBitmap.createdFromMatrix = matrix;
        shadowBitmap.createdFromFilter = filter;
        shadowBitmap.width = width;
        shadowBitmap.height = height;
        return newBitmap;
    }

    @Implementation
    public static Bitmap createBitmap(int[] colors, int width, int height, Bitmap.Config config) {
        if (colors.length != width * height) {
            throw new IllegalArgumentException("array length (" + colors.length + ") did not match width * height (" + width * height + ")");
        }
        Bitmap newBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(newBitmap);
        shadowBitmap.setMutable(false);
        shadowBitmap.createdFromColors = colors;
        shadowBitmap.colors = new int[colors.length];
        System.arraycopy(colors, 0, shadowBitmap.colors, 0, colors.length);
        return newBitmap;
    }

    @Implementation
    public int getPixel(int x, int y) {
        this.internalCheckPixelAccess(x, y);
        if (this.colors != null) {
            return this.colors[y * this.getWidth() + x];
        }
        return 0;
    }

    @Implementation
    public void setPixel(int x, int y, int color) {
        if (this.isRecycled()) {
            throw new IllegalStateException("Can't call setPixel() on a recycled bitmap");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("Bitmap is immutable");
        }
        this.internalCheckPixelAccess(x, y);
        if (this.colors == null) {
            this.colors = new int[this.getWidth() * this.getHeight()];
        }
        this.colors[y * this.getWidth() + x] = color;
    }

    @Implementation
    public void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        if (x != 0 || y != 0 || width != this.getWidth() || height != this.getHeight() || pixels.length != this.colors.length) {
            throw new RuntimeException("Not implemented.");
        }
        System.arraycopy(this.colors, 0, pixels, 0, this.colors.length);
    }

    @Implementation
    public int getRowBytes() {
        return ShadowBitmap.getBytesPerPixel(this.config) * this.getWidth();
    }

    @Implementation
    public int getByteCount() {
        return this.getRowBytes() * this.getHeight();
    }

    @Implementation
    public void recycle() {
        this.recycled = true;
    }

    @Implementation
    public final boolean isRecycled() {
        return this.recycled;
    }

    @Implementation
    public Bitmap copy(Bitmap.Config config, boolean isMutable) {
        Bitmap newBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = Shadows.shadowOf(newBitmap);
        shadowBitmap.createdFromBitmap = this.realBitmap;
        shadowBitmap.config = config;
        shadowBitmap.mutable = isMutable;
        return newBitmap;
    }

    @Implementation
    public final Bitmap.Config getConfig() {
        return this.config;
    }

    @Implementation
    public void setConfig(Bitmap.Config config) {
        this.config = config;
    }

    @Implementation
    public final boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void appendDescription(String s) {
        this.description = this.description + s;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getDescription() {
        return this.description;
    }

    @Implementation
    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    @Implementation
    public void setHasAlpha(boolean hasAlpha) {
        this.hasAlpha = hasAlpha;
    }

    @Implementation
    public final boolean hasMipMap() {
        return this.hasMipMap;
    }

    @Implementation
    public final void setHasMipMap(boolean hasMipMap) {
        this.hasMipMap = hasMipMap;
    }

    @Implementation
    public void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    public int getWidth() {
        return this.width;
    }

    @Implementation
    public void setHeight(int height) {
        this.height = height;
    }

    @Implementation
    public int getHeight() {
        return this.height;
    }

    @Implementation
    public void setDensity(int density) {
        this.density = density;
    }

    @Implementation
    public int getDensity() {
        return this.density;
    }

    @Implementation
    public int getGenerationId() {
        return 0;
    }

    @Implementation
    public Bitmap createAshmemBitmap() {
        return this.realBitmap;
    }

    @Implementation
    public void eraseColor(int c) {
    }

    @Implementation
    public void writeToParcel(Parcel p, int flags) {
        p.writeInt(this.width);
        p.writeInt(this.height);
        p.writeSerializable((Serializable)this.config);
        p.writeIntArray(this.colors);
    }

    @Implementation
    public static Bitmap nativeCreateFromParcel(Parcel p) {
        int parceledWidth = p.readInt();
        int parceledHeight = p.readInt();
        Bitmap.Config parceledConfig = (Bitmap.Config)p.readSerializable();
        int[] parceledColors = new int[parceledHeight * parceledWidth];
        p.readIntArray(parceledColors);
        return ShadowBitmap.createBitmap(parceledColors, parceledWidth, parceledHeight, parceledConfig);
    }

    @Implementation
    public void copyPixelsFromBuffer(Buffer dst) {
        if (this.isRecycled()) {
            throw new IllegalStateException("Can't call copyPixelsFromBuffer() on a recycled bitmap");
        }
        if (ShadowBitmap.getBytesPerPixel(this.config) != 4) {
            throw new RuntimeException("Not implemented: only Bitmaps with 4 bytes per pixel are supported");
        }
        if (!(dst instanceof ByteBuffer)) {
            throw new RuntimeException("Not implemented: unsupported Buffer subclass");
        }
        ByteBuffer byteBuffer = (ByteBuffer)dst;
        if (byteBuffer.remaining() < this.colors.length * 4) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = byteBuffer.getInt();
        }
    }

    @Implementation
    public void copyPixelsToBuffer(Buffer dst) {
        if (ShadowBitmap.getBytesPerPixel(this.config) != 4) {
            throw new RuntimeException("Not implemented: only Bitmaps with 4 bytes per pixel are supported");
        }
        if (!(dst instanceof ByteBuffer)) {
            throw new RuntimeException("Not implemented: unsupported Buffer subclass");
        }
        ByteBuffer byteBuffer = (ByteBuffer)dst;
        for (int color : this.colors) {
            byteBuffer.putInt(color);
        }
    }

    public String toString() {
        return "Bitmap{description='" + this.description + '\'' + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public Bitmap getRealBitmap() {
        return this.realBitmap;
    }

    public static int getBytesPerPixel(Bitmap.Config config) {
        if (config == null) {
            throw new NullPointerException("Bitmap config was null.");
        }
        switch (config) {
            case ARGB_8888: {
                return 4;
            }
            case RGB_565: 
            case ARGB_4444: {
                return 2;
            }
            case ALPHA_8: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown bitmap config: " + config);
    }

    public void setCreatedFromResId(int resId, String description) {
        this.createdFromResId = resId;
        this.appendDescription(" for resource:" + description);
    }

    private void internalCheckPixelAccess(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }
}

