/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.os.IBinder;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import com.android.internal.app.IVoiceInteractor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboMenuItem;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowContextThemeWrapper;
import org.robolectric.shadows.ShadowWindow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Activity.class)
public class ShadowActivity
extends ShadowContextThemeWrapper {
    @RealObject
    protected Activity realActivity;
    private int resultCode;
    private Intent resultIntent;
    private Activity parent;
    private boolean finishWasCalled;
    private List<IntentForResult> startedActivitiesForResults = new ArrayList<IntentForResult>();
    private Map<Intent.FilterComparison, Integer> intentRequestCodeMap = new HashMap<Intent.FilterComparison, Integer>();
    private int requestedOrientation = -1;
    private View currentFocus;
    private Integer lastShownDialogId = null;
    private int pendingTransitionEnterAnimResId = -1;
    private int pendingTransitionExitAnimResId = -1;
    private Object lastNonConfigurationInstance;
    private Map<Integer, Dialog> dialogForId = new HashMap<Integer, Dialog>();
    private ArrayList<Cursor> managedCursors = new ArrayList();
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    private int streamType = -1;
    private boolean mIsTaskRoot = true;
    private Menu optionsMenu;
    private ComponentName callingActivity;

    @Implementation
    public void __constructor__() {
        Shadow.invokeConstructor(Activity.class, (Object)this.realActivity, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setApplication(Application application) {
        ReflectionHelpers.setField((Object)this.realActivity, (String)"mApplication", (Object)application);
    }

    private String getActivityTitle() {
        String title = null;
        AndroidManifest appManifest = ShadowApplication.getInstance().getAppManifest();
        if (appManifest == null) {
            return null;
        }
        String labelRef = appManifest.getActivityLabel(this.realActivity.getClass().getName());
        if (labelRef != null) {
            if (labelRef.startsWith("@")) {
                int labelRes = RuntimeEnvironment.application.getResources().getIdentifier(labelRef.replace("@", ""), "string", appManifest.getPackageName());
                title = RuntimeEnvironment.application.getString(labelRes);
            } else {
                title = labelRef;
            }
        }
        return title;
    }

    public void callAttach(Intent intent) {
        ActivityInfo activityInfo;
        String activityTitle = this.getActivityTitle();
        int apiLevel = RuntimeEnvironment.getApiLevel();
        Application application = RuntimeEnvironment.application;
        Context baseContext = RuntimeEnvironment.application.getBaseContext();
        Class<?> nonConfigurationInstancesClass = this.getNonConfigurationClass();
        try {
            activityInfo = application.getPackageManager().getActivityInfo(new ComponentName(application.getPackageName(), this.realActivity.getClass().getName()), 129);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException();
        }
        if (apiLevel <= 19) {
            ReflectionHelpers.callInstanceMethod(Activity.class, (Object)this.realActivity, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)baseContext), ReflectionHelpers.ClassParameter.from(ActivityThread.class, (Object)RuntimeEnvironment.getActivityThread()), ReflectionHelpers.ClassParameter.from(Instrumentation.class, (Object)new Instrumentation()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Application.class, (Object)application), ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent), ReflectionHelpers.ClassParameter.from(ActivityInfo.class, (Object)activityInfo), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)activityTitle), ReflectionHelpers.ClassParameter.from(Activity.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)"id"), ReflectionHelpers.ClassParameter.from(nonConfigurationInstancesClass, null), ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)application.getResources().getConfiguration())});
        } else if (apiLevel <= 21) {
            ReflectionHelpers.callInstanceMethod(Activity.class, (Object)this.realActivity, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)baseContext), ReflectionHelpers.ClassParameter.from(ActivityThread.class, (Object)RuntimeEnvironment.getActivityThread()), ReflectionHelpers.ClassParameter.from(Instrumentation.class, (Object)new Instrumentation()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Application.class, (Object)application), ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent), ReflectionHelpers.ClassParameter.from(ActivityInfo.class, (Object)activityInfo), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)activityTitle), ReflectionHelpers.ClassParameter.from(Activity.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)"id"), ReflectionHelpers.ClassParameter.from(nonConfigurationInstancesClass, null), ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)application.getResources().getConfiguration()), ReflectionHelpers.ClassParameter.from(IVoiceInteractor.class, null)});
        } else if (apiLevel <= 23) {
            ReflectionHelpers.callInstanceMethod(Activity.class, (Object)this.realActivity, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)baseContext), ReflectionHelpers.ClassParameter.from(ActivityThread.class, (Object)RuntimeEnvironment.getActivityThread()), ReflectionHelpers.ClassParameter.from(Instrumentation.class, (Object)new Instrumentation()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Application.class, (Object)application), ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent), ReflectionHelpers.ClassParameter.from(ActivityInfo.class, (Object)activityInfo), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)activityTitle), ReflectionHelpers.ClassParameter.from(Activity.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)"id"), ReflectionHelpers.ClassParameter.from(nonConfigurationInstancesClass, null), ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)application.getResources().getConfiguration()), ReflectionHelpers.ClassParameter.from(String.class, (Object)"referrer"), ReflectionHelpers.ClassParameter.from(IVoiceInteractor.class, null)});
        } else if (apiLevel <= 25) {
            ReflectionHelpers.callInstanceMethod(Activity.class, (Object)this.realActivity, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)baseContext), ReflectionHelpers.ClassParameter.from(ActivityThread.class, (Object)RuntimeEnvironment.getActivityThread()), ReflectionHelpers.ClassParameter.from(Instrumentation.class, (Object)new Instrumentation()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Application.class, (Object)application), ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent), ReflectionHelpers.ClassParameter.from(ActivityInfo.class, (Object)activityInfo), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)activityTitle), ReflectionHelpers.ClassParameter.from(Activity.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)"id"), ReflectionHelpers.ClassParameter.from(nonConfigurationInstancesClass, null), ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)application.getResources().getConfiguration()), ReflectionHelpers.ClassParameter.from(String.class, (Object)"referrer"), ReflectionHelpers.ClassParameter.from(IVoiceInteractor.class, null), ReflectionHelpers.ClassParameter.from(Window.class, null)});
        } else if (apiLevel >= 26) {
            ReflectionHelpers.callInstanceMethod(Activity.class, (Object)this.realActivity, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)baseContext), ReflectionHelpers.ClassParameter.from(ActivityThread.class, (Object)RuntimeEnvironment.getActivityThread()), ReflectionHelpers.ClassParameter.from(Instrumentation.class, (Object)new Instrumentation()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Application.class, (Object)application), ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent), ReflectionHelpers.ClassParameter.from(ActivityInfo.class, (Object)activityInfo), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)activityTitle), ReflectionHelpers.ClassParameter.from(Activity.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)"id"), ReflectionHelpers.ClassParameter.from(nonConfigurationInstancesClass, null), ReflectionHelpers.ClassParameter.from(Configuration.class, (Object)application.getResources().getConfiguration()), ReflectionHelpers.ClassParameter.from(String.class, (Object)"referrer"), ReflectionHelpers.ClassParameter.from(IVoiceInteractor.class, null), ReflectionHelpers.ClassParameter.from(Window.class, null), ReflectionHelpers.ClassParameter.from(ViewRootImpl.ActivityConfigCallback.class, null)});
        } else {
            throw new RuntimeException("Could not find AndroidRuntimeAdapter for API level: " + apiLevel);
        }
        this.setThemeFromManifest();
    }

    private Class<?> getNonConfigurationClass() {
        try {
            return this.getClass().getClassLoader().loadClass("android.app.Activity$NonConfigurationInstances");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean setThemeFromManifest() {
        ShadowApplication shadowApplication = Shadows.shadowOf(this.realActivity.getApplication());
        AndroidManifest appManifest = shadowApplication.getAppManifest();
        if (appManifest == null) {
            return false;
        }
        String themeRef = appManifest.getThemeRef(this.realActivity.getClass().getName());
        if (themeRef != null) {
            int themeRes = this.realActivity.getResources().getIdentifier(themeRef.replace("@", ""), "style", appManifest.getPackageName());
            this.realActivity.setTheme(themeRes);
            return true;
        }
        return false;
    }

    public void setCallingActivity(ComponentName activityName) {
        this.callingActivity = activityName;
    }

    @Implementation
    public ComponentName getCallingActivity() {
        return this.callingActivity;
    }

    @Implementation
    public void setDefaultKeyMode(int keyMode) {
        this.mDefaultKeyMode = keyMode;
        switch (this.mDefaultKeyMode) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection((Spannable)this.mDefaultKeySsb, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getDefaultKeymode() {
        return this.mDefaultKeyMode;
    }

    @Implementation
    public final void setResult(int resultCode) {
        this.resultCode = resultCode;
    }

    @Implementation
    public final void setResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.resultIntent = data;
    }

    @Implementation
    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.realActivity);
    }

    @Implementation
    public MenuInflater getMenuInflater() {
        return new MenuInflater((Context)this.realActivity);
    }

    @Implementation
    public View findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    @Implementation
    public final Activity getParent() {
        return this.parent;
    }

    @HiddenApi
    @Implementation
    public void setParent(Activity parent) {
        this.parent = parent;
    }

    @Implementation
    public void onBackPressed() {
        this.finish();
    }

    @Implementation
    public void finish() {
        this.finishWasCalled = true;
    }

    @Implementation(minSdk=21)
    public void finishAndRemoveTask() {
        this.finishWasCalled = true;
    }

    @Implementation(minSdk=16)
    public void finishAffinity() {
        this.finishWasCalled = true;
    }

    public void resetIsFinishing() {
        this.finishWasCalled = false;
    }

    @Implementation
    public boolean isFinishing() {
        return this.finishWasCalled;
    }

    @Implementation
    public Window getWindow() {
        Window window = ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).getWindow();
        if (window == null) {
            try {
                window = ShadowWindow.create((Context)this.realActivity);
                this.setWindow(window);
            }
            catch (Exception e) {
                throw new RuntimeException("Window creation failed!", e);
            }
        }
        return window;
    }

    public void setWindow(Window window) {
        ReflectionHelpers.setField((Object)this.realActivity, (String)"mWindow", (Object)window);
    }

    @Implementation
    public void runOnUiThread(Runnable action) {
        ShadowApplication.getInstance().getForegroundThreadScheduler().post(action);
    }

    @Implementation
    public void setRequestedOrientation(int requestedOrientation) {
        if (this.getParent() != null) {
            this.getParent().setRequestedOrientation(requestedOrientation);
        } else {
            this.requestedOrientation = requestedOrientation;
        }
    }

    @Implementation
    public int getRequestedOrientation() {
        if (this.getParent() != null) {
            return this.getParent().getRequestedOrientation();
        }
        return this.requestedOrientation;
    }

    @Implementation
    public int getTaskId() {
        return 0;
    }

    public View getContentView() {
        return ((ViewGroup)this.getWindow().findViewById(0x1020002)).getChildAt(0);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Intent getResultIntent() {
        return this.resultIntent;
    }

    public IntentForResult getNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.remove(0);
    }

    public IntentForResult peekNextStartedActivityForResult() {
        if (this.startedActivitiesForResults.isEmpty()) {
            return null;
        }
        return this.startedActivitiesForResults.get(0);
    }

    @Implementation
    public Object getLastNonConfigurationInstance() {
        return this.lastNonConfigurationInstance;
    }

    public void setLastNonConfigurationInstance(Object lastNonConfigurationInstance) {
        this.lastNonConfigurationInstance = lastNonConfigurationInstance;
    }

    public void setCurrentFocus(View view) {
        this.currentFocus = view;
    }

    @Implementation
    public View getCurrentFocus() {
        return this.currentFocus;
    }

    public int getPendingTransitionEnterAnimationResourceId() {
        return this.pendingTransitionEnterAnimResId;
    }

    public int getPendingTransitionExitAnimationResourceId() {
        return this.pendingTransitionExitAnimResId;
    }

    @Implementation
    public boolean onCreateOptionsMenu(Menu menu) {
        this.optionsMenu = menu;
        return ((Activity)Shadow.directlyOn((Object)this.realActivity, Activity.class)).onCreateOptionsMenu(menu);
    }

    public Menu getOptionsMenu() {
        return this.optionsMenu;
    }

    public boolean clickMenuItem(int menuItemResId) {
        if (this.optionsMenu == null) {
            throw new RuntimeException("Activity does not have an options menu! Did you forget to call super.onCreateOptionsMenu(menu) in " + this.realActivity.getClass().getName() + "?");
        }
        RoboMenuItem item = new RoboMenuItem(menuItemResId);
        return this.realActivity.onMenuItemSelected(0, (MenuItem)item);
    }

    @Implementation
    public void startActivities(Intent[] intents, Bundle options) {
        for (int i = intents.length - 1; i >= 0; --i) {
            ShadowApplication.getInstance().startActivity(intents[i], options);
        }
    }

    @Implementation
    public void startActivityForResult(Intent intent, int requestCode) {
        this.intentRequestCodeMap.put(new Intent.FilterComparison(intent), requestCode);
        this.startedActivitiesForResults.add(new IntentForResult(intent, requestCode));
        ShadowApplication.getInstance().startActivity(intent);
    }

    @Implementation
    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        this.intentRequestCodeMap.put(new Intent.FilterComparison(intent), requestCode);
        this.startedActivitiesForResults.add(new IntentForResult(intent, requestCode, options));
        ShadowApplication.getInstance().startActivity(intent);
    }

    public void receiveResult(Intent requestIntent, int resultCode, Intent resultIntent) {
        Integer requestCode = this.intentRequestCodeMap.get(new Intent.FilterComparison(requestIntent));
        if (requestCode == null) {
            throw new RuntimeException("No intent matches " + requestIntent + " among " + this.intentRequestCodeMap.keySet());
        }
        ActivityInvoker invoker = new ActivityInvoker();
        invoker.call("onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class).with(requestCode, resultCode, resultIntent);
    }

    @Implementation
    public final void showDialog(int id2) {
        this.showDialog(id2, null);
    }

    @Implementation
    public final void dismissDialog(int id2) {
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        dialog.dismiss();
    }

    @Implementation
    public final void removeDialog(int id2) {
        this.dialogForId.remove(id2);
    }

    @Implementation
    public final boolean showDialog(int id2, Bundle bundle) {
        this.lastShownDialogId = id2;
        Dialog dialog = this.dialogForId.get(id2);
        if (dialog == null) {
            ActivityInvoker invoker = new ActivityInvoker();
            dialog = (Dialog)invoker.call("onCreateDialog", Integer.TYPE).with(id2);
            if (dialog == null) {
                return false;
            }
            if (bundle == null) {
                invoker.call("onPrepareDialog", Integer.TYPE, Dialog.class).with(id2, dialog);
            } else {
                invoker.call("onPrepareDialog", Integer.TYPE, Dialog.class, Bundle.class).with(id2, dialog, bundle);
            }
            this.dialogForId.put(id2, dialog);
        }
        dialog.show();
        return true;
    }

    public void setIsTaskRoot(boolean isRoot) {
        this.mIsTaskRoot = isRoot;
    }

    @Implementation
    public final boolean isTaskRoot() {
        return this.mIsTaskRoot;
    }

    public Integer getLastShownDialogId() {
        return this.lastShownDialogId;
    }

    public boolean hasCancelledPendingTransitions() {
        return this.pendingTransitionEnterAnimResId == 0 && this.pendingTransitionExitAnimResId == 0;
    }

    @Implementation
    public void overridePendingTransition(int enterAnim, int exitAnim) {
        this.pendingTransitionEnterAnimResId = enterAnim;
        this.pendingTransitionExitAnimResId = exitAnim;
    }

    public Dialog getDialogById(int dialogId) {
        return this.dialogForId.get(dialogId);
    }

    @Implementation
    public void recreate() {
        Bundle outState = new Bundle();
        ActivityInvoker invoker = new ActivityInvoker();
        invoker.call("onSaveInstanceState", Bundle.class).with(outState);
        invoker.call("onPause", new Class[0]).withNothing();
        invoker.call("onStop", new Class[0]).withNothing();
        Object nonConfigInstance = invoker.call("onRetainNonConfigurationInstance", new Class[0]).withNothing();
        this.setLastNonConfigurationInstance(nonConfigInstance);
        invoker.call("onDestroy", new Class[0]).withNothing();
        invoker.call("onCreate", Bundle.class).with(outState);
        invoker.call("onStart", new Class[0]).withNothing();
        invoker.call("onRestoreInstanceState", Bundle.class).with(outState);
        invoker.call("onResume", new Class[0]).withNothing();
    }

    @Implementation
    public void startManagingCursor(Cursor c) {
        this.managedCursors.add(c);
    }

    @Implementation
    public void stopManagingCursor(Cursor c) {
        this.managedCursors.remove(c);
    }

    public List<Cursor> getManagedCursors() {
        return this.managedCursors;
    }

    @Implementation
    public final void setVolumeControlStream(int streamType) {
        this.streamType = streamType;
    }

    @Implementation
    public final int getVolumeControlStream() {
        return this.streamType;
    }

    @Implementation
    public void startActivityFromFragment(Fragment fragment, Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode);
    }

    @Implementation
    public void startActivityFromFragment(Fragment fragment, Intent intent, int requestCode, Bundle options) {
        this.startActivityForResult(intent, requestCode, options);
    }

    @Implementation(minSdk=23)
    public final void requestPermissions(String[] permissions, int requestCode) {
    }

    private final class ActivityInvoker {
        private Method method;

        private ActivityInvoker() {
        }

        public ActivityInvoker call(String methodName, Class ... argumentClasses) {
            try {
                this.method = Activity.class.getDeclaredMethod(methodName, argumentClasses);
                this.method.setAccessible(true);
                return this;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public Object withNothing() {
            return this.with(new Object[0]);
        }

        public Object with(Object ... parameters) {
            try {
                return this.method.invoke((Object)ShadowActivity.this.realActivity, parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class IntentForResult {
        public Intent intent;
        public int requestCode;
        public Bundle options;

        public IntentForResult(Intent intent, int requestCode) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = null;
        }

        public IntentForResult(Intent intent, int requestCode, Bundle options) {
            this.intent = intent;
            this.requestCode = requestCode;
            this.options = options;
        }
    }
}

