/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.os.Looper;
import org.robolectric.Shadows;
import org.robolectric.ShadowsAdapter;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.Scheduler;

public class CoreShadowsAdapter
implements ShadowsAdapter {
    @Override
    public Scheduler getBackgroundScheduler() {
        return ShadowApplication.getInstance().getBackgroundThreadScheduler();
    }

    @Override
    public ShadowsAdapter.ShadowLooperAdapter getMainLooper() {
        final ShadowLooper shadow = Shadows.shadowOf(Looper.getMainLooper());
        return new ShadowsAdapter.ShadowLooperAdapter(){

            @Override
            public void runPaused(Runnable runnable) {
                shadow.runPaused(runnable);
            }
        };
    }

    @Override
    public String getShadowActivityThreadClassName() {
        return "android.app.ActivityThread";
    }

    @Override
    public void setupLogging() {
        ShadowLog.setupLogging();
    }

    @Override
    public String getShadowContextImplClassName() {
        return "android.app.ContextImpl";
    }

    @Override
    public void bind(Application application, AndroidManifest appManifest) {
        Shadows.shadowOf(application).bind(appManifest);
    }
}

