/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Priority;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.internal.bytecode.ShadowMap;

public class ShadowProviders {
    private final ImmutableList<ShadowProvider> shadowProviders;
    private final ShadowMap baseShadowMap;

    public ShadowProviders(List<ShadowProvider> shadowProviders) {
        this.shadowProviders = ImmutableList.sortedCopyOf(Comparator.comparing(ShadowProviders::priority).reversed().thenComparing(ShadowProviders::name), shadowProviders);
        this.baseShadowMap = ShadowMap.createFromShadowProviders(this.shadowProviders);
    }

    public ShadowMap getBaseShadowMap() {
        return this.baseShadowMap;
    }

    private static int priority(ShadowProvider shadowProvider) {
        Priority priority = shadowProvider.getClass().getAnnotation(Priority.class);
        return priority == null ? 0 : priority.value();
    }

    private static String name(ShadowProvider shadowProvider) {
        return shadowProvider.getClass().getName();
    }

    public List<String> getInstrumentedPackages() {
        HashSet packages = new HashSet();
        for (ShadowProvider shadowProvider : this.shadowProviders) {
            Collections.addAll(packages, shadowProvider.getProvidedPackageNames());
        }
        return new ArrayList<String>(packages);
    }

    public ShadowProvider[] inClassLoader(ClassLoader classLoader) {
        ShadowProvider[] inCL = new ShadowProvider[this.shadowProviders.size()];
        for (int i = 0; i < this.shadowProviders.size(); ++i) {
            ShadowProvider shadowProvider = (ShadowProvider)this.shadowProviders.get(i);
            String name = shadowProvider.getClass().getName();
            try {
                inCL[i] = classLoader.loadClass(name).asSubclass(ShadowProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("couldn't reload " + name + " in " + classLoader, e);
            }
        }
        return inCL;
    }
}

