/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.robolectric.internal.bytecode.RoboCallSite;

public class MethodCallSite
extends RoboCallSite {
    private final String name;
    private final MethodHandle original;
    private final Kind kind;
    private final boolean isNative;

    public MethodCallSite(Class<?> theClass, MethodType type, String name, MethodHandle original, Kind kind, boolean isNative) {
        super(type, theClass);
        this.name = name;
        this.original = original;
        this.kind = kind;
        this.isNative = isNative;
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getOriginal() {
        return this.original;
    }

    public Class<?> thisType() {
        return this.isStatic() ? null : this.type().parameterType(0);
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String toString() {
        return "RoboCallSite{theClass=" + this.getTheClass() + ", original=" + this.original + ", kind=" + (Object)((Object)this.kind) + '}';
    }

    public static enum Kind {
        REGULAR,
        STATIC;

    }
}

