/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

public class CleanerCompat {
    private static final String CLEANER_CLASS_NAME = "java.lang.ref.Cleaner";
    private static final String CLEANABLE_CLASS_NAME = "java.lang.ref.Cleaner$Cleanable";
    private static final CleanerReflector CLEANER;

    public static Object register(Object obj, Runnable action) {
        return CLEANER.register(obj, action);
    }

    public static void clean(Object cleanable) {
        ((CleanableReflector)Reflector.reflector(CleanableReflector.class, (Object)cleanable)).clean();
    }

    static {
        Object cleaner = ((CleanerReflector)Reflector.reflector(CleanerReflector.class)).create();
        CLEANER = (CleanerReflector)Reflector.reflector(CleanerReflector.class, (Object)cleaner);
    }

    @ForType(className="java.lang.ref.Cleaner")
    static interface CleanerReflector {
        @Static
        public Object create();

        public Object register(Object var1, Runnable var2);
    }

    @ForType(className="java.lang.ref.Cleaner$Cleanable")
    static interface CleanableReflector {
        public void clean();
    }
}

