/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

abstract class ClassValueMap<T> {
    private final Map<Class<?>, T> map = Collections.synchronizedMap(new WeakHashMap());

    ClassValueMap() {
    }

    protected abstract T computeValue(Class<?> var1);

    public T get(Class<?> type) {
        return (T)this.map.computeIfAbsent(type, this::computeValue);
    }

    @VisibleForTesting
    void clear() {
        this.map.clear();
    }
}

