/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

enum RoboType {
    VOID(Void.TYPE),
    BOOLEAN(Boolean.TYPE),
    BYTE(Byte.TYPE),
    CHAR(Character.TYPE),
    SHORT(Short.TYPE),
    INT(Integer.TYPE),
    LONG(Long.TYPE),
    FLOAT(Float.TYPE),
    DOUBLE(Double.TYPE),
    OBJECT(null);

    private final Class type;

    private RoboType(Class type) {
        this.type = type;
    }

    public static Class findPrimitiveClass(String name) {
        for (RoboType type : RoboType.values()) {
            if (type.type == null || !type.type.getName().equals(name)) continue;
            return type.type;
        }
        return null;
    }
}

