/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateClickableBoundsViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.AccessibilityValidator;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.robolectric.annotation.AccessibilityChecks;

public class AccessibilityUtil {
    private static final String COMPAT_V4_CLASS_NAME = "android.support.v4.view.ViewCompat";
    private static AccessibilityValidator validator;
    private static boolean forVersionSet;
    private static boolean v4SupportPresenceVerified;

    private AccessibilityUtil() {
    }

    public static List<AccessibilityViewCheckResult> checkViewIfCheckingEnabled(View view) {
        AccessibilityChecks classChecksAnnotation = AccessibilityUtil.getAnnotation();
        if (!AccessibilityUtil.isAccessibilityCheckingEnabled(classChecksAnnotation)) {
            return Collections.emptyList();
        }
        return AccessibilityUtil.checkView(view);
    }

    public static List<AccessibilityViewCheckResult> checkView(View view) {
        return AccessibilityUtil.checkView(view, AccessibilityUtil.getAnnotation());
    }

    @Deprecated
    public static boolean passesAccessibilityChecksIfEnabled(View view) {
        AccessibilityUtil.setThrowExceptionForErrors(false);
        List<AccessibilityViewCheckResult> results = AccessibilityUtil.checkViewIfCheckingEnabled(view);
        List errors = AccessibilityCheckResultUtils.getResultsForType(results, (AccessibilityCheckResult.AccessibilityCheckResultType)AccessibilityCheckResult.AccessibilityCheckResultType.ERROR);
        return errors.size() == 0;
    }

    public static void setRunChecksForRobolectricVersion(AccessibilityChecks.ForRobolectricVersion forVersion) {
        AccessibilityUtil.initializeValidator();
        if (forVersion != null) {
            validator.setCheckPreset(AccessibilityUtil.convertRoboVersionToA11yTestVersion(forVersion));
            forVersionSet = true;
        } else {
            forVersionSet = false;
        }
    }

    public static void setRunChecksFromRootView(boolean runChecksFromRootView) {
        AccessibilityUtil.initializeValidator();
        validator.setRunChecksFromRootView(runChecksFromRootView);
    }

    public static void setSuppressingResultMatcher(Matcher<? super AccessibilityViewCheckResult> matcher) {
        AccessibilityUtil.initializeValidator();
        Matcher touchTargetResultMatcher = AccessibilityCheckResultUtils.matchesChecks((Matcher)Matchers.equalTo(TouchTargetSizeViewCheck.class));
        Matcher duplicateBoundsResultMatcher = AccessibilityCheckResultUtils.matchesChecks((Matcher)Matchers.equalTo(DuplicateClickableBoundsViewCheck.class));
        if (matcher == null) {
            validator.setSuppressingResultMatcher((Matcher)Matchers.anyOf((Matcher)touchTargetResultMatcher, (Matcher)duplicateBoundsResultMatcher));
        } else {
            validator.setSuppressingResultMatcher((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{matcher, touchTargetResultMatcher, duplicateBoundsResultMatcher}));
        }
    }

    public static void setThrowExceptionForErrors(boolean throwExceptionForErrors) {
        AccessibilityUtil.initializeValidator();
        validator.setThrowExceptionForErrors(throwExceptionForErrors);
    }

    private static List<AccessibilityViewCheckResult> checkView(View view, AccessibilityChecks classChecksAnnotation) {
        if (!v4SupportPresenceVerified) {
            try {
                View.class.getClassLoader().loadClass(COMPAT_V4_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Accessibility Checking requires the Android support library (v4).\nEither include it in the project or disable accessibility checking.");
            }
            v4SupportPresenceVerified = true;
        }
        AccessibilityUtil.initializeValidator();
        if (!forVersionSet) {
            if (classChecksAnnotation != null) {
                validator.setCheckPreset(AccessibilityUtil.convertRoboVersionToA11yTestVersion(classChecksAnnotation.forRobolectricVersion()));
            } else {
                validator.setCheckPreset(AccessibilityCheckPreset.LATEST);
            }
        }
        return validator.checkAndReturnResults(view);
    }

    private static boolean isAccessibilityCheckingEnabled(AccessibilityChecks classChecksAnnotation) {
        boolean checksEnabled = false;
        String checksEnabledString = System.getenv("robolectric.accessibility.enablechecks");
        if (checksEnabledString != null) {
            checksEnabled = checksEnabledString.equals("true");
        }
        if ((checksEnabledString = System.getProperty("robolectric.accessibility.enablechecks")) != null) {
            checksEnabled = checksEnabledString.equals("true");
        }
        if (classChecksAnnotation != null) {
            checksEnabled = classChecksAnnotation.enabled();
        }
        return checksEnabled;
    }

    private static AccessibilityChecks getAnnotation() {
        StackTraceElement[] stack;
        AccessibilityChecks classChecksAnnotation = null;
        for (StackTraceElement element : stack = new Throwable().fillInStackTrace().getStackTrace()) {
            try {
                Class<?> clazz = Class.forName(element.getClassName());
                Method method = clazz.getMethod(element.getMethodName(), new Class[0]);
                classChecksAnnotation = method.getAnnotation(AccessibilityChecks.class);
                if (classChecksAnnotation == null) {
                    classChecksAnnotation = clazz.getAnnotation(AccessibilityChecks.class);
                }
                if (classChecksAnnotation == null && clazz.getAnnotation(Test.class) == null) continue;
                break;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                // empty catch block
            }
        }
        return classChecksAnnotation;
    }

    private static void initializeValidator() {
        if (validator == null) {
            validator = new AccessibilityValidator();
            AccessibilityUtil.setSuppressingResultMatcher(null);
        }
    }

    private static AccessibilityCheckPreset convertRoboVersionToA11yTestVersion(AccessibilityChecks.ForRobolectricVersion robolectricVersion) {
        if (robolectricVersion == AccessibilityChecks.ForRobolectricVersion.LATEST) {
            return AccessibilityCheckPreset.LATEST;
        }
        AccessibilityCheckPreset preset = AccessibilityCheckPreset.VERSION_1_0_CHECKS;
        if (robolectricVersion.ordinal() >= AccessibilityChecks.ForRobolectricVersion.VERSION_3_1.ordinal()) {
            preset = AccessibilityCheckPreset.VERSION_2_0_CHECKS;
        }
        return preset;
    }

    static {
        forVersionSet = false;
        v4SupportPresenceVerified = false;
    }
}

