/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal;

import org.robolectric.internal.ProxyMaker;
import org.robolectric.internal.bytecode.DirectObjectMarker;
import org.robolectric.internal.bytecode.InvokeDynamic;
import org.robolectric.util.ReflectionHelpers;

public class Shadow {
    private static final ProxyMaker PROXY_MAKER = new ProxyMaker(new ProxyMaker.MethodMapper(){

        @Override
        public String getName(String className, String methodName) {
            return Shadow.directMethodName(methodName);
        }
    });

    public static <T> T newInstanceOf(Class<T> clazz) {
        return ReflectionHelpers.callConstructor(clazz, new ReflectionHelpers.ClassParameter[0]);
    }

    public static Object newInstanceOf(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null) {
                return Shadow.newInstanceOf(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz, Class[] parameterTypes, Object[] params) {
        return ReflectionHelpers.callConstructor(clazz, ReflectionHelpers.ClassParameter.fromComponentLists(parameterTypes, params));
    }

    public static <T> T directlyOn(T shadowedObject, Class<T> clazz) {
        if (InvokeDynamic.ENABLED) {
            return PROXY_MAKER.createProxy(clazz, shadowedObject);
        }
        return ReflectionHelpers.callConstructor(clazz, ReflectionHelpers.ClassParameter.fromComponentLists(new Class[]{DirectObjectMarker.class, clazz}, new Object[]{DirectObjectMarker.INSTANCE, shadowedObject}));
    }

    public static <R> R directlyOn(Object shadowedObject, String clazzName, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        try {
            Class<?> aClass = shadowedObject.getClass().getClassLoader().loadClass(clazzName);
            return Shadow.directlyOn(shadowedObject, aClass, methodName, paramValues);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R, T> R directlyOn(T shadowedObject, Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = Shadow.directMethodName(methodName);
        return ReflectionHelpers.callInstanceMethod(clazz, shadowedObject, directMethodName, paramValues);
    }

    public static <R, T> R directlyOn(Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = Shadow.directMethodName(methodName);
        return ReflectionHelpers.callStaticMethod(clazz, directMethodName, paramValues);
    }

    public static <R> R invokeConstructor(Class<? extends R> clazz, R instance, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = Shadow.directMethodName("__constructor__");
        return ReflectionHelpers.callInstanceMethod(clazz, instance, directMethodName, paramValues);
    }

    public static String directMethodName(String methodName) {
        return "$$robo$$" + methodName;
    }
}

