/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.ByteBuffer;
import org.robolectric.res.android.DataType;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.String8;
import org.robolectric.res.android.Util;

public class ResXMLParser {
    static final int SIZEOF_RESXMLTREE_NAMESPACE_EXT = 4;
    static final int SIZEOF_RESXMLTREE_NODE = ResourceTypes.ResChunk_header.SIZEOF + 8;
    static final int SIZEOF_RESXMLTREE_ATTR_EXT = 20;
    static final int SIZEOF_RESXMLTREE_CDATA_EXT = 12;
    static final int SIZEOF_CHAR = 2;
    ResXMLTree mTree;
    int mEventCode;
    ResourceTypes.ResXMLTree_node mCurNode;
    int mCurExt;
    int mSourceResourceId;

    public ResXMLParser(ResXMLTree tree) {
        this.mTree = tree;
        this.mEventCode = -1;
    }

    public void restart() {
        this.mCurNode = null;
        this.mEventCode = this.mTree.mError == 0 ? 0 : -1;
    }

    public ResStringPool getStrings() {
        return this.mTree.mStrings;
    }

    int getEventType() {
        return this.mEventCode;
    }

    public int next() {
        if (this.mEventCode == 0) {
            this.mCurNode = this.mTree.mRootNode;
            this.mCurExt = this.mTree.mRootExt;
            this.mEventCode = this.mTree.mRootCode;
            return this.mEventCode;
        }
        if (this.mEventCode >= 256) {
            return this.nextNode();
        }
        return this.mEventCode;
    }

    int getCommentID() {
        return this.mCurNode != null ? Util.dtohl(this.mCurNode.comment.index) : -1;
    }

    final String getComment(Ref<Integer> outLen) {
        int id = this.getCommentID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    public int getLineNumber() {
        return this.mCurNode != null ? Util.dtohl(this.mCurNode.lineNumber) : -1;
    }

    public int getTextID() {
        if (this.mEventCode == 260) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_cdataExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).data.index);
        }
        return -1;
    }

    final String getText(Ref<Integer> outLen) {
        int id = this.getTextID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    int getTextValue(ResourceTypes.Res_value outValue) {
        if (this.mEventCode == 260) {
            return 8;
        }
        return -2147483646;
    }

    int getNamespacePrefixID() {
        if (this.mEventCode == 256 || this.mEventCode == 257) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_namespaceExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).prefix.index);
        }
        return -1;
    }

    final String getNamespacePrefix(Ref<Integer> outLen) {
        int id = this.getNamespacePrefixID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    int getNamespaceUriID() {
        if (this.mEventCode == 256 || this.mEventCode == 257) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_namespaceExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).uri.index);
        }
        return -1;
    }

    final String getNamespaceUri(Ref<Integer> outLen) {
        int id = this.getNamespaceUriID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    public int getElementNamespaceID() {
        if (this.mEventCode == 258) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).ns.index);
        }
        if (this.mEventCode == 259) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_endElementExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).ns.index);
        }
        return -1;
    }

    final String getElementNamespace(Ref<Integer> outLen) {
        int id = this.getElementNamespaceID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    public int getElementNameID() {
        if (this.mEventCode == 258) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).name.index);
        }
        if (this.mEventCode == 259) {
            return Util.dtohl(new ResourceTypes.ResXMLTree_endElementExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).name.index);
        }
        return -1;
    }

    final String getElementName(Ref<Integer> outLen) {
        int id = this.getElementNameID();
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    public int getAttributeCount() {
        if (this.mEventCode == 258) {
            return Util.dtohs(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).attributeCount);
        }
        return 0;
    }

    public int getAttributeNamespaceID(int idx) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                return Util.dtohl(attr.ns.index);
            }
        }
        return -2;
    }

    final String getAttributeNamespace(int idx, Ref<Integer> outLen) {
        int id = this.getAttributeNamespaceID(idx);
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    final String getAttributeNamespace8(int idx, Ref<Integer> outLen) {
        int id = this.getAttributeNamespaceID(idx);
        return id >= 0 ? this.mTree.mStrings.string8At(id, outLen) : null;
    }

    public int getAttributeNameID(int idx) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                return Util.dtohl(attr.name.index);
            }
        }
        return -1;
    }

    final String getAttributeName(int idx, Ref<Integer> outLen) {
        int id = this.getAttributeNameID(idx);
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    final String getAttributeName8(int idx, Ref<Integer> outLen) {
        int id = this.getAttributeNameID(idx);
        return id >= 0 ? this.mTree.mStrings.string8At(id, outLen) : null;
    }

    public int getAttributeNameResID(int idx) {
        int id = this.getAttributeNameID(idx);
        if (id >= 0 && id < this.mTree.mNumResIds) {
            int resId = Util.dtohl(this.mTree.mResIds[id]);
            if (this.mTree.mDynamicRefTable != null) {
                Ref<Integer> resIdRef = new Ref<Integer>(resId);
                this.mTree.mDynamicRefTable.lookupResourceId(resIdRef);
                resId = resIdRef.get();
            }
            return resId;
        }
        return 0;
    }

    public int getAttributeValueStringID(int idx) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                return Util.dtohl(attr.rawValue.index);
            }
        }
        return -1;
    }

    final String getAttributeStringValue(int idx, Ref<Integer> outLen) {
        int id = this.getAttributeValueStringID(idx);
        return id >= 0 ? this.mTree.mStrings.stringAt(id, outLen) : null;
    }

    public int getAttributeDataType(int idx) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                byte type = attr.typedValue.dataType;
                if (type != DataType.DYNAMIC_REFERENCE.code()) {
                    return type;
                }
                return DataType.REFERENCE.code();
            }
        }
        return DataType.NULL.code();
    }

    public int getAttributeData(int idx) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                if (attr.typedValue.dataType != DataType.DYNAMIC_REFERENCE.code() || this.mTree.mDynamicRefTable == null) {
                    return Util.dtohl(attr.typedValue.data);
                }
                Ref<Integer> data = new Ref<Integer>(Util.dtohl(attr.typedValue.data));
                if (this.mTree.mDynamicRefTable.lookupResourceId(data) == 0) {
                    return data.get();
                }
            }
        }
        return 0;
    }

    public int getAttributeValue(int idx, Ref<ResourceTypes.Res_value> outValue) {
        if (this.mEventCode == 258) {
            ResourceTypes.ResXMLTree_attrExt tag = new ResourceTypes.ResXMLTree_attrExt(this.mTree.mBuffer.buf, this.mCurExt);
            if (idx < Util.dtohs(tag.attributeCount)) {
                ResourceTypes.ResXMLTree_attribute attr = tag.attributeAt(idx);
                outValue.set(attr.typedValue);
                if (this.mTree.mDynamicRefTable != null && this.mTree.mDynamicRefTable.lookupResourceValue(outValue) != 0) {
                    return -2147483646;
                }
                return 8;
            }
        }
        return -2147483646;
    }

    int indexOfAttribute(String ns, String attr) {
        String nsStr = ns != null ? ns : "";
        String attrStr = attr;
        return this.indexOfAttribute(Util.isTruthy(ns) ? nsStr : null, Util.isTruthy(ns) ? nsStr.length() : 0, attrStr, attrStr.length());
    }

    public int indexOfAttribute(String ns, int nsLen, String attr, int attrLen) {
        block6: {
            if (this.mEventCode != 258) break block6;
            if (attr == null) {
                return -2147483643;
            }
            int N = this.getAttributeCount();
            if (this.mTree.mStrings.isUTF8()) {
                String8 ns8 = null;
                if (ns != null) {
                    ns8 = new String8(ns, nsLen);
                }
                String8 attr8 = new String8(attr, attrLen);
                for (int i = 0; i < N; ++i) {
                    Ref<Integer> curNsLen = new Ref<Integer>(0);
                    Ref<Integer> curAttrLen = new Ref<Integer>(0);
                    String curNs = this.getAttributeNamespace8(i, curNsLen);
                    String curAttr = this.getAttributeName8(i, curAttrLen);
                    if (curAttr == null || curNsLen.get() != nsLen || curAttrLen.get() != attrLen || this.memcmp(attr8.string(), curAttr, attrLen) != 0 || !(ns == null ? curNs == null : curNs != null && this.memcmp(ns8.string(), curNs, nsLen) == 0)) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < N; ++i) {
                    Ref<Integer> curNsLen = new Ref<Integer>(0);
                    Ref<Integer> curAttrLen = new Ref<Integer>(0);
                    String curNs = this.getAttributeNamespace(i, curNsLen);
                    String curAttr = this.getAttributeName(i, curAttrLen);
                    if (curAttr == null || curNsLen.get() != nsLen || curAttrLen.get() != attrLen || this.memcmp(attr, curAttr, attrLen * 2) != 0 || !(ns == null ? curNs == null : curNs != null && this.memcmp(ns, curNs, nsLen * 2) == 0)) continue;
                    return i;
                }
            }
        }
        return -2147483643;
    }

    private int memcmp(String s1, String s2, int len) {
        for (int i = 0; i < len; ++i) {
            int d = s1.charAt(i) - s2.charAt(i);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public int indexOfID() {
        short idx;
        if (this.mEventCode == 258 && (idx = Util.dtohs(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).idIndex)) > 0) {
            return idx - 1;
        }
        return -2147483643;
    }

    public int indexOfClass() {
        short idx;
        if (this.mEventCode == 258 && (idx = Util.dtohs(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).classIndex)) > 0) {
            return idx - 1;
        }
        return -2147483643;
    }

    public int indexOfStyle() {
        short idx;
        if (this.mEventCode == 258 && (idx = Util.dtohs(new ResourceTypes.ResXMLTree_attrExt((ByteBuffer)this.mTree.mBuffer.buf, (int)this.mCurExt).styleIndex)) > 0) {
            return idx - 1;
        }
        return -2147483643;
    }

    int nextNode() {
        short eventCode;
        int minExtSize;
        int totalSize;
        short headerSize;
        ResourceTypes.ResXMLTree_node next;
        if (this.mEventCode < 0) {
            return this.mEventCode;
        }
        block6: while (true) {
            int nextOffset;
            if ((nextOffset = this.mCurNode.myOffset() + Util.dtohl(this.mCurNode.header.size)) >= this.mTree.mDataLen) {
                this.mCurNode = null;
                this.mEventCode = 1;
                return 1;
            }
            next = new ResourceTypes.ResXMLTree_node(this.mTree.mBuffer.buf, nextOffset);
            if (next.myOffset() >= this.mTree.mDataLen) {
                this.mCurNode = null;
                this.mEventCode = 1;
                return 1;
            }
            if (this.mTree.validateNode(next) != 0) {
                this.mCurNode = null;
                this.mEventCode = -1;
                return -1;
            }
            this.mCurNode = next;
            headerSize = Util.dtohs(next.header.headerSize);
            totalSize = Util.dtohl(next.header.size);
            this.mCurExt = next.myOffset() + headerSize;
            minExtSize = 0;
            short s = eventCode = Util.dtohs(next.header.type);
            this.mEventCode = s;
            switch (s) {
                case 256: 
                case 257: {
                    minExtSize = 4;
                    break block6;
                }
                case 258: {
                    minExtSize = 20;
                    break block6;
                }
                case 259: {
                    minExtSize = 8;
                    break block6;
                }
                case 260: {
                    minExtSize = 12;
                    break block6;
                }
                default: {
                    Util.ALOGW("Unknown XML block: header type %d in node at %d\n", Util.dtohs(next.header.type), next.myOffset() - this.mTree.mHeader.myOffset());
                    continue block6;
                }
            }
            break;
        }
        if (totalSize - headerSize < minExtSize) {
            Util.ALOGW("Bad XML block: header type 0x%x in node at 0x%x has size %d, need %d\n", Util.dtohs(next.header.type), next.myOffset() - this.mTree.mHeader.myOffset(), totalSize - headerSize, minExtSize);
            this.mEventCode = -1;
            return -1;
        }
        return eventCode;
    }

    void getPosition(ResXMLPosition pos) {
        pos.eventCode = this.mEventCode;
        pos.curNode = this.mCurNode;
        pos.curExt = this.mCurExt;
    }

    void setPosition(ResXMLPosition pos) {
        this.mEventCode = pos.eventCode;
        this.mCurNode = pos.curNode;
        this.mCurExt = pos.curExt;
    }

    public void setSourceResourceId(int resId) {
        this.mSourceResourceId = resId;
    }

    public int getSourceResourceId() {
        return this.mSourceResourceId;
    }

    static class ResXMLPosition {
        int eventCode;
        ResourceTypes.ResXMLTree_node curNode;
        int curExt;

        ResXMLPosition() {
        }
    }

    public static class event_code_t {
        public static final int BAD_DOCUMENT = -1;
        public static final int START_DOCUMENT = 0;
        public static final int END_DOCUMENT = 1;
        public static final int FIRST_CHUNK_CODE = 256;
        public static final int START_NAMESPACE = 256;
        public static final int END_NAMESPACE = 257;
        public static final int START_TAG = 258;
        public static final int END_TAG = 259;
        public static final int TEXT = 260;
    }
}

