/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.nio.file.Path;
import java.util.ArrayDeque;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.DocumentLoader;
import org.robolectric.res.Fs;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.XmlContext;

public class StaxDocumentLoader
extends DocumentLoader {
    private static final NodeHandler NO_OP_HANDLER = new NodeHandler();
    private final NodeHandler topLevelNodeHandler;
    private final XMLInputFactory factory;

    public StaxDocumentLoader(String packageName, Path resourceBase, NodeHandler topLevelNodeHandler) {
        super(packageName, resourceBase);
        this.topLevelNodeHandler = topLevelNodeHandler;
        this.factory = XMLInputFactory.newFactory();
    }

    @Override
    protected void loadResourceXmlFile(XmlContext xmlContext) {
        XMLStreamReader xmlStreamReader;
        Path xmlFile = xmlContext.getXmlFile();
        try {
            xmlStreamReader = this.factory.createXMLStreamReader(Fs.getInputStream(xmlFile));
            this.doParse(xmlStreamReader, xmlContext);
        }
        catch (Exception e) {
            throw new RuntimeException("error parsing " + xmlFile, e);
        }
        if (xmlStreamReader != null) {
            try {
                xmlStreamReader.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void doParse(XMLStreamReader reader, XmlContext xmlContext) throws XMLStreamException {
        NodeHandler nodeHandler = this.topLevelNodeHandler;
        ArrayDeque<NodeHandler> nodeHandlerStack = new ArrayDeque<NodeHandler>();
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 7: {
                    break;
                }
                case 1: {
                    nodeHandlerStack.push(nodeHandler);
                    NodeHandler elementHandler = nodeHandler.findMatchFor(reader);
                    nodeHandler = elementHandler == null ? NO_OP_HANDLER : elementHandler;
                    nodeHandler.onStart(reader, xmlContext);
                    break;
                }
                case 4: 
                case 12: {
                    nodeHandler.onCharacters(reader, xmlContext);
                    break;
                }
                case 2: {
                    nodeHandler.onEnd(reader, xmlContext);
                    nodeHandler = (NodeHandler)nodeHandlerStack.pop();
                    break;
                }
            }
        }
    }
}

