/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.robolectric.res.android.DataType;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;

public class DynamicRefTable {
    final byte mAssignedPackageId;
    final byte[] mLookupTable = new byte[256];
    final Map<String, Byte> mEntries = new HashMap<String, Byte>();
    boolean mAppAsLib;
    final Map<Integer, Integer> mAliasId = new HashMap<Integer, Integer>();

    DynamicRefTable(byte packageId, boolean appAsLib) {
        this.mAssignedPackageId = packageId;
        this.mAppAsLib = appAsLib;
        this.mLookupTable[127] = 127;
        this.mLookupTable[1] = 1;
    }

    int addMappings(DynamicRefTable other) {
        if (this.mAssignedPackageId != other.mAssignedPackageId) {
            return Integer.MIN_VALUE;
        }
        for (Map.Entry<String, Byte> otherEntry : other.mEntries.entrySet()) {
            String key = otherEntry.getKey();
            Byte curValue = this.mEntries.get(key);
            if (curValue == null) {
                this.mEntries.put(key, otherEntry.getValue());
                continue;
            }
            if (Objects.equals(otherEntry.getValue(), curValue)) continue;
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < 256; ++i) {
            if (this.mLookupTable[i] == other.mLookupTable[i]) continue;
            if (this.mLookupTable[i] == 0) {
                this.mLookupTable[i] = other.mLookupTable[i];
                continue;
            }
            if (other.mLookupTable[i] == 0) continue;
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    int addMapping(String packageName, byte packageId) {
        Byte index = this.mEntries.get(packageName);
        if (index == null) {
            return Integer.MIN_VALUE;
        }
        this.mLookupTable[index.byteValue()] = packageId;
        return 0;
    }

    void addAlias(int stagedId, int finalizedId) {
        this.mAliasId.put(stagedId, finalizedId);
    }

    int lookupResourceId(Ref<Integer> resId) {
        int res = resId.get();
        int packageId = ResTable.Res_GETPACKAGE(res) + 1;
        Integer aliasId = this.mAliasId.get(res);
        if (aliasId != null) {
            res = aliasId;
        }
        if (packageId == 1 || packageId == 127 && !this.mAppAsLib) {
            resId.set(res);
            return 0;
        }
        if (packageId == 0 || packageId == 127 && this.mAppAsLib) {
            resId.set(0xFFFFFF & resId.get() | this.mAssignedPackageId << 24);
            return 0;
        }
        byte translatedId = this.mLookupTable[packageId];
        if (translatedId == 0) {
            Util.ALOGW("DynamicRefTable(0x%02x): No mapping for build-time package ID 0x%02x.", this.mAssignedPackageId, packageId);
            for (int i = 0; i < 256; ++i) {
                if (this.mLookupTable[i] == 0) continue;
                Util.ALOGW("e[0x%02x] . 0x%02x", i, this.mLookupTable[i]);
            }
            return Integer.MIN_VALUE;
        }
        resId.set(res & 0xFFFFFF | translatedId << 24);
        return 0;
    }

    int lookupResourceValue(Ref<ResourceTypes.Res_value> value) {
        DataType dataType;
        byte resolvedType = DataType.REFERENCE.code();
        ResourceTypes.Res_value inValue = value.get();
        try {
            dataType = DataType.fromCode(inValue.dataType);
        }
        catch (IllegalArgumentException e) {
            return -2147483646;
        }
        switch (dataType) {
            case ATTRIBUTE: {
                resolvedType = DataType.ATTRIBUTE.code();
            }
            case REFERENCE: {
                if (this.mAppAsLib) break;
                return 0;
            }
            case DYNAMIC_ATTRIBUTE: {
                resolvedType = DataType.ATTRIBUTE.code();
            }
            case DYNAMIC_REFERENCE: {
                break;
            }
            default: {
                return 0;
            }
        }
        Ref<Integer> resIdRef = new Ref<Integer>(inValue.data);
        int err = this.lookupResourceId(resIdRef);
        value.set(inValue.withData(resIdRef.get()));
        if (err != 0) {
            return err;
        }
        value.set(new ResourceTypes.Res_value(resolvedType, (int)resIdRef.get()));
        return 0;
    }

    public Map<String, Byte> entries() {
        return this.mEntries;
    }
}

