/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.ByteBuffer;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;

class Chunk {
    private final ResourceTypes.ResChunk_header device_chunk_;

    Chunk(ResourceTypes.ResChunk_header chunk) {
        this.device_chunk_ = chunk;
    }

    int type() {
        return Util.dtohs(this.device_chunk_.type);
    }

    int size() {
        return Util.dtohl(this.device_chunk_.size);
    }

    int header_size() {
        return Util.dtohs(this.device_chunk_.headerSize);
    }

    ByteBuffer myBuf() {
        return this.device_chunk_.myBuf();
    }

    int myOffset() {
        return this.device_chunk_.myOffset();
    }

    public ResourceTypes.WithOffset data_ptr() {
        return new ResourceTypes.WithOffset(this.device_chunk_.myBuf(), this.device_chunk_.myOffset() + this.header_size());
    }

    int data_size() {
        return this.size() - this.header_size();
    }

    public ResourceTypes.ResTable_header asResTable_header() {
        if (this.header_size() >= ResourceTypes.ResTable_header.SIZEOF) {
            return new ResourceTypes.ResTable_header(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResStringPool_header asResStringPool_header() {
        if (this.header_size() >= ResourceTypes.ResStringPool_header.SIZEOF) {
            return new ResourceTypes.ResStringPool_header(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResTable_package asResTable_package(int size) {
        if (this.header_size() >= size) {
            return new ResourceTypes.ResTable_package(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResTable_type asResTable_type(int size) {
        if (this.header_size() >= size) {
            return new ResourceTypes.ResTable_type(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResTable_lib_header asResTable_lib_header() {
        if (this.header_size() >= ResourceTypes.ResTable_lib_header.SIZEOF) {
            return new ResourceTypes.ResTable_lib_header(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResTable_lib_entry asResTable_lib_entry() {
        if (this.data_size() >= 260) {
            return new ResourceTypes.ResTable_lib_entry(this.device_chunk_.myBuf(), this.device_chunk_.myOffset() + this.header_size());
        }
        return null;
    }

    public ResourceTypes.ResTableStagedAliasHeader asResTableStagedAliasHeader() {
        if (this.header_size() >= ResourceTypes.ResTableStagedAliasHeader.SIZEOF) {
            return new ResourceTypes.ResTableStagedAliasHeader(this.device_chunk_.myBuf(), this.device_chunk_.myOffset());
        }
        return null;
    }

    public ResourceTypes.ResTableStagedAliasEntry asResTableStagedAliasEntry() {
        if (this.data_size() >= 8) {
            return new ResourceTypes.ResTableStagedAliasEntry(this.device_chunk_.myBuf(), this.device_chunk_.myOffset() + this.header_size());
        }
        return null;
    }

    static class Iterator {
        private ResourceTypes.ResChunk_header next_chunk_;
        private int len_;
        private String last_error_;
        private boolean last_error_was_fatal_ = true;

        public Iterator(ResourceTypes.WithOffset buf, int itemSize) {
            this.next_chunk_ = new ResourceTypes.ResChunk_header(buf.myBuf(), buf.myOffset());
            this.len_ = itemSize;
        }

        boolean HasNext() {
            return !this.HadError() && this.len_ != 0;
        }

        boolean HadError() {
            return this.last_error_ != null;
        }

        String GetLastError() {
            return this.last_error_;
        }

        boolean HadFatalError() {
            return this.HadError() && this.last_error_was_fatal_;
        }

        Chunk Next() {
            assert (this.len_ != 0) : "called Next() after last chunk";
            ResourceTypes.ResChunk_header this_chunk = this.next_chunk_;
            int remaining = this.len_ - Util.dtohl(this_chunk.size);
            this.next_chunk_ = remaining <= 0 ? null : new ResourceTypes.ResChunk_header(this_chunk.myBuf(), this_chunk.myOffset() + Util.dtohl(this_chunk.size));
            this.len_ -= Util.dtohl(this_chunk.size);
            if (this.len_ != 0 && this.VerifyNextChunkNonFatal()) {
                this.VerifyNextChunk();
            }
            return new Chunk(this_chunk);
        }

        boolean VerifyNextChunkNonFatal() {
            if (this.len_ < ResourceTypes.ResChunk_header.SIZEOF) {
                this.last_error_ = "not enough space for header";
                this.last_error_was_fatal_ = false;
                return false;
            }
            int size = Util.dtohl(this.next_chunk_.size);
            if (size > this.len_) {
                this.last_error_ = "chunk size is bigger than given data";
                this.last_error_was_fatal_ = false;
                return false;
            }
            return true;
        }

        boolean VerifyNextChunk() {
            int header_start = this.next_chunk_.myOffset();
            if (Util.isTruthy(header_start & 3)) {
                this.last_error_ = "header not aligned on 4-byte boundary";
                return false;
            }
            if (this.len_ < ResourceTypes.ResChunk_header.SIZEOF) {
                this.last_error_ = "not enough space for header";
                return false;
            }
            short header_size = Util.dtohs(this.next_chunk_.headerSize);
            int size = Util.dtohl(this.next_chunk_.size);
            if (header_size < ResourceTypes.ResChunk_header.SIZEOF) {
                this.last_error_ = "header size too small";
                return false;
            }
            if (header_size > size) {
                this.last_error_ = "header size is larger than entire chunk";
                return false;
            }
            if (size > this.len_) {
                this.last_error_ = "chunk size is bigger than given data";
                return false;
            }
            if (Util.isTruthy((size | header_size) & 3)) {
                this.last_error_ = "header sizes are not aligned on 4-byte boundary";
                return false;
            }
            return true;
        }
    }
}

