/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralRules;
import org.robolectric.res.ResType;
import org.robolectric.res.StaxLoader;
import org.robolectric.res.TextCollectingNodeHandler;
import org.robolectric.res.XmlContext;

public class StaxPluralsLoader
extends StaxLoader {
    protected String name;
    private String quantity;
    private final List<Plural> plurals = new ArrayList<Plural>();

    public StaxPluralsLoader(PackageResourceTable resourceTable, String attrType, ResType charSequence) {
        super(resourceTable, attrType, charSequence);
        this.addHandler("item", new NodeHandler(){
            private final StringBuilder buf = new StringBuilder();

            @Override
            public void onStart(XMLStreamReader xml, XmlContext xmlContext) {
                StaxPluralsLoader.this.quantity = xml.getAttributeValue(null, "quantity");
                this.buf.setLength(0);
            }

            @Override
            public void onCharacters(XMLStreamReader xml, XmlContext xmlContext) {
                this.buf.append(xml.getText());
            }

            @Override
            public void onEnd(XMLStreamReader xml, XmlContext xmlContext) {
                StaxPluralsLoader.this.plurals.add(new Plural(StaxPluralsLoader.this.quantity, this.buf.toString()));
            }

            @Override
            NodeHandler findMatchFor(XMLStreamReader xml) {
                return new TextCollectingNodeHandler(this.buf);
            }
        });
    }

    @Override
    public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.name = xml.getAttributeValue(null, "name");
    }

    @Override
    public void onEnd(XMLStreamReader xml, XmlContext xmlContext) {
        this.resourceTable.addResource(this.attrType, this.name, new PluralRules((List<Plural>)new ArrayList<Plural>(this.plurals), this.resType, xmlContext));
        this.plurals.clear();
    }
}

