/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.robolectric.res.DirBaseNameFilter;
import org.robolectric.res.Fs;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;

public abstract class DocumentLoader {
    protected final String packageName;
    private final Path resourceBase;

    public DocumentLoader(String packageName, Path resourceBase) {
        this.packageName = packageName;
        this.resourceBase = resourceBase;
    }

    public void load(String folderBaseName) throws IOException {
        for (Path dir : Fs.listFiles(this.resourceBase, new DirBaseNameFilter(folderBaseName))) {
            this.loadFile(dir);
        }
    }

    private void loadFile(Path dir) throws IOException {
        Qualifiers qualifiers;
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new RuntimeException("no such directory " + dir);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try {
            qualifiers = Qualifiers.fromParentDir(dir);
        }
        catch (IllegalArgumentException e) {
            Logger.warn((String)(dir + ": " + e.getMessage()), (Object[])new Object[0]);
            return;
        }
        for (Path file : Fs.listFiles(dir, path -> path.getFileName().toString().endsWith(".xml"))) {
            this.loadResourceXmlFile(new XmlContext(this.packageName, file, qualifiers));
        }
    }

    protected abstract void loadResourceXmlFile(XmlContext var1);
}

