/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.pluginapi;

import java.nio.file.Path;
import javax.annotation.Nonnull;

public abstract class Sdk
implements Comparable<Sdk> {
    private final int apiLevel;

    protected Sdk(int apiLevel) {
        this.apiLevel = apiLevel;
    }

    public final int getApiLevel() {
        return this.apiLevel;
    }

    public abstract String getAndroidVersion();

    public abstract String getAndroidCodeName();

    public abstract Path getJarPath();

    public abstract boolean isSupported();

    public abstract String getUnsupportedMessage();

    public boolean isKnown() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sdk)) {
            return false;
        }
        Sdk sdk = (Sdk)o;
        return this.apiLevel == sdk.apiLevel;
    }

    public int hashCode() {
        return this.apiLevel;
    }

    public String toString() {
        return "SDK " + this.apiLevel;
    }

    @Override
    public int compareTo(@Nonnull Sdk o) {
        return this.apiLevel - o.apiLevel;
    }

    public abstract void verifySupportedSdk(String var1);
}

