/*
 * Decompiled with CFR 0.152.
 */
package com.android.timezone.distro.installer;

import android.util.Slog;
import com.android.timezone.distro.DistroException;
import com.android.timezone.distro.DistroVersion;
import com.android.timezone.distro.FileUtils;
import com.android.timezone.distro.StagedDistroOperation;
import com.android.timezone.distro.TimeZoneDistro;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import libcore.util.TimeZoneFinder;
import libcore.util.ZoneInfoDB;

public class TimeZoneDistroInstaller {
    public static final int INSTALL_SUCCESS = 0;
    public static final int INSTALL_FAIL_BAD_DISTRO_STRUCTURE = 1;
    public static final int INSTALL_FAIL_BAD_DISTRO_FORMAT_VERSION = 2;
    public static final int INSTALL_FAIL_RULES_TOO_OLD = 3;
    public static final int INSTALL_FAIL_VALIDATION_ERROR = 4;
    public static final int UNINSTALL_SUCCESS = 0;
    public static final int UNINSTALL_NOTHING_INSTALLED = 1;
    public static final int UNINSTALL_FAIL = 2;
    private static final String STAGED_TZ_DATA_DIR_NAME = "staged";
    private static final String CURRENT_TZ_DATA_DIR_NAME = "current";
    private static final String WORKING_DIR_NAME = "working";
    private static final String OLD_TZ_DATA_DIR_NAME = "old";
    public static final String UNINSTALL_TOMBSTONE_FILE_NAME = "STAGED_UNINSTALL_TOMBSTONE";
    private final String logTag;
    private final File systemTzDataFile;
    private final File oldStagedDataDir;
    private final File stagedTzDataDir;
    private final File currentTzDataDir;
    private final File workingDir;

    public TimeZoneDistroInstaller(String logTag, File systemTzDataFile, File installDir) {
        this.logTag = logTag;
        this.systemTzDataFile = systemTzDataFile;
        this.oldStagedDataDir = new File(installDir, OLD_TZ_DATA_DIR_NAME);
        this.stagedTzDataDir = new File(installDir, STAGED_TZ_DATA_DIR_NAME);
        this.currentTzDataDir = new File(installDir, CURRENT_TZ_DATA_DIR_NAME);
        this.workingDir = new File(installDir, WORKING_DIR_NAME);
    }

    File getOldStagedDataDir() {
        return this.oldStagedDataDir;
    }

    File getStagedTzDataDir() {
        return this.stagedTzDataDir;
    }

    File getCurrentTzDataDir() {
        return this.currentTzDataDir;
    }

    File getWorkingDir() {
        return this.workingDir;
    }

    public boolean install(TimeZoneDistro distro) throws IOException {
        int result = this.stageInstallWithErrorCode(distro);
        return result == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int stageInstallWithErrorCode(TimeZoneDistro distro) throws IOException {
        if (this.oldStagedDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldStagedDataDir);
        }
        if (this.workingDir.exists()) {
            FileUtils.deleteRecursive(this.workingDir);
        }
        Slog.i(this.logTag, "Unpacking / verifying time zone update");
        try {
            DistroVersion distroVersion;
            this.unpackDistro(distro, this.workingDir);
            try {
                distroVersion = this.readDistroVersion(this.workingDir);
            }
            catch (DistroException e) {
                Slog.i(this.logTag, "Invalid distro version: " + e.getMessage());
                int n = 1;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            if (distroVersion == null) {
                Slog.i(this.logTag, "Update not applied: Distro version could not be loaded");
                int e = 1;
                return e;
            }
            if (!DistroVersion.isCompatibleWithThisDevice(distroVersion)) {
                Slog.i(this.logTag, "Update not applied: Distro format version check failed: " + distroVersion);
                int e = 2;
                return e;
            }
            if (!this.checkDistroDataFilesExist(this.workingDir)) {
                Slog.i(this.logTag, "Update not applied: Distro is missing required data file(s)");
                int e = 1;
                return e;
            }
            if (!this.checkDistroRulesNewerThanSystem(this.systemTzDataFile, distroVersion)) {
                Slog.i(this.logTag, "Update not applied: Distro rules version check failed");
                int e = 3;
                return e;
            }
            File zoneInfoFile = new File(this.workingDir, "tzdata");
            ZoneInfoDB.TzData tzData = ZoneInfoDB.TzData.loadTzData(zoneInfoFile.getPath());
            if (tzData == null) {
                Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " could not be loaded");
                int n = 4;
                return n;
            }
            try {
                tzData.validate();
            }
            catch (IOException e) {
                Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " failed validation", e);
                int n = 4;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            finally {
                tzData.close();
            }
            File tzLookupFile = new File(this.workingDir, "tzlookup.xml");
            if (!tzLookupFile.exists()) {
                Slog.i(this.logTag, "Update not applied: " + tzLookupFile + " does not exist");
                int n = 1;
                return n;
            }
            try {
                TimeZoneFinder timeZoneFinder = TimeZoneFinder.createInstance(tzLookupFile.getPath());
                timeZoneFinder.validate();
            }
            catch (IOException e) {
                Slog.i(this.logTag, "Update not applied: " + tzLookupFile + " failed validation", e);
                int n = 4;
                this.deleteBestEffort(this.oldStagedDataDir);
                this.deleteBestEffort(this.workingDir);
                return n;
            }
            Slog.i(this.logTag, "Applying time zone update");
            FileUtils.makeDirectoryWorldAccessible(this.workingDir);
            if (!this.stagedTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to unstage at " + this.stagedTzDataDir);
            } else {
                Slog.i(this.logTag, "Moving " + this.stagedTzDataDir + " to " + this.oldStagedDataDir);
                FileUtils.rename(this.stagedTzDataDir, this.oldStagedDataDir);
            }
            Slog.i(this.logTag, "Moving " + this.workingDir + " to " + this.stagedTzDataDir);
            FileUtils.rename(this.workingDir, this.stagedTzDataDir);
            Slog.i(this.logTag, "Install staged: " + this.stagedTzDataDir + " successfully created");
            int n = 0;
            return n;
        }
        finally {
            this.deleteBestEffort(this.oldStagedDataDir);
            this.deleteBestEffort(this.workingDir);
        }
    }

    public int stageUninstall() throws IOException {
        Slog.i(this.logTag, "Uninstalling time zone update");
        if (this.oldStagedDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldStagedDataDir);
        }
        if (this.workingDir.exists()) {
            FileUtils.deleteRecursive(this.workingDir);
        }
        try {
            if (!this.stagedTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to unstage at " + this.stagedTzDataDir);
            } else {
                Slog.i(this.logTag, "Moving " + this.stagedTzDataDir + " to " + this.oldStagedDataDir);
                FileUtils.rename(this.stagedTzDataDir, this.oldStagedDataDir);
            }
            if (!this.currentTzDataDir.exists()) {
                Slog.i(this.logTag, "Nothing to uninstall at " + this.currentTzDataDir);
                int n = 1;
                return n;
            }
            FileUtils.ensureDirectoriesExist(this.workingDir, true);
            FileUtils.createEmptyFile(new File(this.workingDir, UNINSTALL_TOMBSTONE_FILE_NAME));
            Slog.i(this.logTag, "Moving " + this.workingDir + " to " + this.stagedTzDataDir);
            FileUtils.rename(this.workingDir, this.stagedTzDataDir);
            Slog.i(this.logTag, "Uninstall staged: " + this.stagedTzDataDir + " successfully created");
            int n = 0;
            return n;
        }
        finally {
            this.deleteBestEffort(this.oldStagedDataDir);
            this.deleteBestEffort(this.workingDir);
        }
    }

    public DistroVersion getInstalledDistroVersion() throws DistroException, IOException {
        if (!this.currentTzDataDir.exists()) {
            return null;
        }
        return this.readDistroVersion(this.currentTzDataDir);
    }

    public StagedDistroOperation getStagedDistroOperation() throws DistroException, IOException {
        if (!this.stagedTzDataDir.exists()) {
            return null;
        }
        if (new File(this.stagedTzDataDir, UNINSTALL_TOMBSTONE_FILE_NAME).exists()) {
            return StagedDistroOperation.uninstall();
        }
        return StagedDistroOperation.install(this.readDistroVersion(this.stagedTzDataDir));
    }

    public String getSystemRulesVersion() throws IOException {
        return this.readSystemRulesVersion(this.systemTzDataFile);
    }

    private void deleteBestEffort(File dir) {
        if (dir.exists()) {
            Slog.i(this.logTag, "Deleting " + dir);
            try {
                FileUtils.deleteRecursive(dir);
            }
            catch (IOException e) {
                Slog.w(this.logTag, "Unable to delete " + dir, e);
            }
        }
    }

    private void unpackDistro(TimeZoneDistro distro, File targetDir) throws IOException {
        Slog.i(this.logTag, "Unpacking update content to: " + targetDir);
        distro.extractTo(targetDir);
    }

    private boolean checkDistroDataFilesExist(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying distro contents");
        return FileUtils.filesExist(unpackedContentDir, "tzdata", "icu/icu_tzdata.dat");
    }

    private DistroVersion readDistroVersion(File distroDir) throws DistroException, IOException {
        Slog.d(this.logTag, "Reading distro format version: " + distroDir);
        File distroVersionFile = new File(distroDir, "distro_version");
        if (!distroVersionFile.exists()) {
            throw new DistroException("No distro version file found: " + distroVersionFile);
        }
        byte[] versionBytes = FileUtils.readBytes(distroVersionFile, DistroVersion.DISTRO_VERSION_FILE_LENGTH);
        return DistroVersion.fromBytes(versionBytes);
    }

    private boolean checkDistroRulesNewerThanSystem(File systemTzDataFile, DistroVersion distroVersion) throws IOException {
        boolean canApply;
        Slog.i(this.logTag, "Reading /system rules version");
        String systemRulesVersion = this.readSystemRulesVersion(systemTzDataFile);
        String distroRulesVersion = distroVersion.rulesVersion;
        boolean bl = canApply = distroRulesVersion.compareTo(systemRulesVersion) >= 0;
        if (!canApply) {
            Slog.i(this.logTag, "Failed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        } else {
            Slog.i(this.logTag, "Passed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        }
        return canApply;
    }

    private String readSystemRulesVersion(File systemTzDataFile) throws IOException {
        if (!systemTzDataFile.exists()) {
            Slog.i(this.logTag, "tzdata file cannot be found in /system");
            throw new FileNotFoundException("system tzdata does not exist: " + systemTzDataFile);
        }
        return ZoneInfoDB.TzData.getRulesVersion(systemTzDataFile);
    }
}

