/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.util.Pools;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowState;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;

class WindowContainer<E extends WindowContainer>
implements Comparable<WindowContainer> {
    static final int POSITION_TOP = Integer.MAX_VALUE;
    static final int POSITION_BOTTOM = Integer.MIN_VALUE;
    private WindowContainer mParent = null;
    protected final WindowList<E> mChildren = new WindowList();
    private Configuration mOverrideConfiguration = new Configuration();
    private Configuration mFullConfiguration = new Configuration();
    private Configuration mMergedOverrideConfiguration = new Configuration();
    protected int mOrientation = -1;
    private final Pools.SynchronizedPool<ForAllWindowsConsumerWrapper> mConsumerWrapperPool = new Pools.SynchronizedPool(3);
    private WindowContainerController mController;
    private final LinkedList<WindowContainer> mTmpChain1 = new LinkedList();
    private final LinkedList<WindowContainer> mTmpChain2 = new LinkedList();

    WindowContainer() {
    }

    protected final WindowContainer getParent() {
        return this.mParent;
    }

    protected final void setParent(WindowContainer parent) {
        this.mParent = parent;
        if (this.mParent != null) {
            this.onConfigurationChanged(this.mParent.mFullConfiguration);
            this.onMergedOverrideConfigurationChanged();
        }
        this.onParentSet();
    }

    void onParentSet() {
    }

    protected void addChild(E child, Comparator<E> comparator) {
        if (((WindowContainer)child).getParent() != null) {
            throw new IllegalArgumentException("addChild: container=" + ((WindowContainer)child).getName() + " is already a child of container=" + ((WindowContainer)child).getParent().getName() + " can't add to container=" + this.getName());
        }
        int positionToAdd = -1;
        if (comparator != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                if (comparator.compare(child, this.mChildren.get(i)) >= 0) continue;
                positionToAdd = i;
                break;
            }
        }
        if (positionToAdd == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(positionToAdd, child);
        }
        ((WindowContainer)child).setParent(this);
    }

    void addChild(E child, int index) {
        if (((WindowContainer)child).getParent() != null) {
            throw new IllegalArgumentException("addChild: container=" + ((WindowContainer)child).getName() + " is already a child of container=" + ((WindowContainer)child).getParent().getName() + " can't add to container=" + this.getName());
        }
        this.mChildren.add(index, child);
        ((WindowContainer)child).setParent(this);
    }

    void removeChild(E child) {
        if (!this.mChildren.remove(child)) {
            throw new IllegalArgumentException("removeChild: container=" + ((WindowContainer)child).getName() + " is not a child of container=" + this.getName());
        }
        ((WindowContainer)child).setParent(null);
    }

    void removeImmediately() {
        while (!this.mChildren.isEmpty()) {
            WindowContainer child = (WindowContainer)this.mChildren.peekLast();
            child.removeImmediately();
            this.mChildren.remove(child);
        }
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
        if (this.mController != null) {
            this.setController(null);
        }
    }

    void removeIfPossible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.removeIfPossible();
        }
    }

    boolean hasChild(WindowContainer child) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer current = (WindowContainer)this.mChildren.get(i);
            if (current != child && !current.hasChild(child)) continue;
            return true;
        }
        return false;
    }

    void positionChildAt(int position, E child, boolean includingParents) {
        if (((WindowContainer)child).getParent() != this) {
            throw new IllegalArgumentException("removeChild: container=" + ((WindowContainer)child).getName() + " is not a child of container=" + this.getName() + " current parent=" + ((WindowContainer)child).getParent());
        }
        if (position < 0 && position != Integer.MIN_VALUE || position > this.mChildren.size() && position != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("positionAt: invalid position=" + position + ", children number=" + this.mChildren.size());
        }
        if (position >= this.mChildren.size() - 1) {
            position = Integer.MAX_VALUE;
        } else if (position == 0) {
            position = Integer.MIN_VALUE;
        }
        switch (position) {
            case 0x7FFFFFFF: {
                if (this.mChildren.peekLast() != child) {
                    this.mChildren.remove(child);
                    this.mChildren.add(child);
                }
                if (!includingParents || this.getParent() == null) break;
                this.getParent().positionChildAt(Integer.MAX_VALUE, this, true);
                break;
            }
            case -2147483648: {
                if (this.mChildren.peekFirst() != child) {
                    this.mChildren.remove(child);
                    this.mChildren.addFirst(child);
                }
                if (!includingParents || this.getParent() == null) break;
                this.getParent().positionChildAt(Integer.MIN_VALUE, this, true);
                break;
            }
            default: {
                this.mChildren.remove(child);
                this.mChildren.add(position, child);
            }
        }
    }

    Configuration getConfiguration() {
        return this.mFullConfiguration;
    }

    void onConfigurationChanged(Configuration newParentConfig) {
        this.mFullConfiguration.setTo(newParentConfig);
        this.mFullConfiguration.updateFrom(this.mOverrideConfiguration);
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer child = (WindowContainer)this.mChildren.get(i);
            child.onConfigurationChanged(this.mFullConfiguration);
        }
    }

    Configuration getOverrideConfiguration() {
        return this.mOverrideConfiguration;
    }

    void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
        this.mOverrideConfiguration.setTo(overrideConfiguration);
        this.onConfigurationChanged(this.mParent != null ? this.mParent.getConfiguration() : Configuration.EMPTY);
        this.onMergedOverrideConfigurationChanged();
        if (this.mParent != null) {
            this.mParent.onDescendantOverrideConfigurationChanged();
        }
    }

    void onDescendantOverrideConfigurationChanged() {
        if (this.mParent != null) {
            this.mParent.onDescendantOverrideConfigurationChanged();
        }
    }

    Configuration getMergedOverrideConfiguration() {
        return this.mMergedOverrideConfiguration;
    }

    private void onMergedOverrideConfigurationChanged() {
        if (this.mParent != null) {
            this.mMergedOverrideConfiguration.setTo(this.mParent.getMergedOverrideConfiguration());
            this.mMergedOverrideConfiguration.updateFrom(this.mOverrideConfiguration);
        } else {
            this.mMergedOverrideConfiguration.setTo(this.mOverrideConfiguration);
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer child = (WindowContainer)this.mChildren.get(i);
            child.onMergedOverrideConfigurationChanged();
        }
    }

    void onDisplayChanged(DisplayContent dc) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer child = (WindowContainer)this.mChildren.get(i);
            child.onDisplayChanged(dc);
        }
    }

    void setWaitingForDrawnIfResizingChanged() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.setWaitingForDrawnIfResizingChanged();
        }
    }

    void onResize() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onResize();
        }
    }

    void onMovedByResize() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onMovedByResize();
        }
    }

    void resetDragResizingChangeReported() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.resetDragResizingChangeReported();
        }
    }

    void forceWindowsScaleableInTransaction(boolean force) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.forceWindowsScaleableInTransaction(force);
        }
    }

    boolean isAnimating() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(j);
            if (!wc.isAnimating()) continue;
            return true;
        }
        return false;
    }

    void sendAppVisibilityToClients() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.sendAppVisibilityToClients();
        }
    }

    void setVisibleBeforeClientHidden() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.setVisibleBeforeClientHidden();
        }
    }

    boolean hasContentToDisplay() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            if (!wc.hasContentToDisplay()) continue;
            return true;
        }
        return false;
    }

    boolean isVisible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            if (!wc.isVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isOnTop() {
        return this.getParent().getTopChild() == this && this.getParent().isOnTop();
    }

    E getTopChild() {
        return (E)((WindowContainer)this.mChildren.peekLast());
    }

    boolean checkCompleteDeferredRemoval() {
        boolean stillDeferringRemoval = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            stillDeferringRemoval |= wc.checkCompleteDeferredRemoval();
        }
        return stillDeferringRemoval;
    }

    void checkAppWindowsReadyToShow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.checkAppWindowsReadyToShow();
        }
    }

    void stepAppWindowsAnimation(long currentTime) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.stepAppWindowsAnimation(currentTime);
        }
    }

    void onAppTransitionDone() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onAppTransitionDone();
        }
    }

    void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    int getOrientation() {
        return this.getOrientation(this.mOrientation);
    }

    int getOrientation(int candidate) {
        if (!this.fillsParent()) {
            return -2;
        }
        if (this.mOrientation != -2 && this.mOrientation != -1) {
            return this.mOrientation;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            int orientation = wc.getOrientation(candidate == 3 ? 3 : -2);
            if (orientation == 3) {
                candidate = orientation;
                continue;
            }
            if (orientation == -2 || !wc.fillsParent() && orientation == -1) continue;
            return orientation;
        }
        return candidate;
    }

    boolean fillsParent() {
        return false;
    }

    void switchUser() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowContainer)this.mChildren.get(i)).switchUser();
        }
    }

    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (traverseTopToBottom) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                if (!((WindowContainer)this.mChildren.get(i)).forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        } else {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                if (!((WindowContainer)this.mChildren.get(i)).forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        }
        return false;
    }

    void forAllWindows(Consumer<WindowState> callback, boolean traverseTopToBottom) {
        ForAllWindowsConsumerWrapper wrapper = this.obtainConsumerWrapper(callback);
        this.forAllWindows(wrapper, traverseTopToBottom);
        wrapper.release();
    }

    void forAllTasks(Consumer<Task> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowContainer)this.mChildren.get(i)).forAllTasks(callback);
        }
    }

    WindowState getWindow(Predicate<WindowState> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = ((WindowContainer)this.mChildren.get(i)).getWindow(callback);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(WindowContainer other) {
        if (this == other) {
            return 0;
        }
        if (this.mParent != null && this.mParent == other.mParent) {
            WindowList<E> list = this.mParent.mChildren;
            return list.indexOf(this) > list.indexOf(other) ? 1 : -1;
        }
        LinkedList<WindowContainer> thisParentChain = this.mTmpChain1;
        LinkedList<WindowContainer> otherParentChain = this.mTmpChain2;
        try {
            this.getParents(thisParentChain);
            other.getParents(otherParentChain);
            WindowContainer commonAncestor = null;
            WindowContainer thisTop = thisParentChain.peekLast();
            WindowContainer otherTop = otherParentChain.peekLast();
            while (thisTop != null && otherTop != null && thisTop == otherTop) {
                commonAncestor = thisParentChain.removeLast();
                otherParentChain.removeLast();
                thisTop = thisParentChain.peekLast();
                otherTop = otherParentChain.peekLast();
            }
            if (commonAncestor == null) {
                throw new IllegalArgumentException("No in the same hierarchy this=" + thisParentChain + " other=" + otherParentChain);
            }
            if (commonAncestor == this) {
                int n = -1;
                return n;
            }
            if (commonAncestor == other) {
                int n = 1;
                return n;
            }
            WindowList<E> list = commonAncestor.mChildren;
            int n = list.indexOf(thisParentChain.peekLast()) > list.indexOf(otherParentChain.peekLast()) ? 1 : -1;
            return n;
        }
        finally {
            this.mTmpChain1.clear();
            this.mTmpChain2.clear();
        }
    }

    private void getParents(LinkedList<WindowContainer> parents) {
        parents.clear();
        WindowContainer current = this;
        do {
            parents.addLast(current);
        } while ((current = current.mParent) != null);
    }

    WindowContainerController getController() {
        return this.mController;
    }

    void setController(WindowContainerController controller) {
        if (this.mController != null && controller != null) {
            throw new IllegalArgumentException("Can't set controller=" + this.mController + " for container=" + this + " Already set to=" + this.mController);
        }
        if (controller != null) {
            controller.setContainer(this);
        } else if (this.mController != null) {
            this.mController.setContainer(null);
        }
        this.mController = controller;
    }

    void dumpChildrenNames(StringBuilder out, String prefix) {
        String childPrefix = prefix + " ";
        out.append(this.getName() + "\n");
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            out.append(childPrefix + "#" + i + " ");
            wc.dumpChildrenNames(out, childPrefix);
        }
    }

    String getName() {
        return this.toString();
    }

    private ForAllWindowsConsumerWrapper obtainConsumerWrapper(Consumer<WindowState> consumer) {
        ForAllWindowsConsumerWrapper wrapper = this.mConsumerWrapperPool.acquire();
        if (wrapper == null) {
            wrapper = new ForAllWindowsConsumerWrapper();
        }
        wrapper.setConsumer(consumer);
        return wrapper;
    }

    private final class ForAllWindowsConsumerWrapper
    implements ToBooleanFunction<WindowState> {
        private Consumer<WindowState> mConsumer;

        private ForAllWindowsConsumerWrapper() {
        }

        void setConsumer(Consumer<WindowState> consumer) {
            this.mConsumer = consumer;
        }

        @Override
        public boolean apply(WindowState w) {
            this.mConsumer.accept(w);
            return false;
        }

        void release() {
            this.mConsumer = null;
            WindowContainer.this.mConsumerWrapperPool.release(this);
        }
    }
}

