/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowSurfaceController;

class SurfaceControlWithBackground
extends SurfaceControl {
    private SurfaceControl mBackgroundControl;
    private boolean mVisible;
    private WindowSurfaceController mWindowSurfaceController;
    private Rect mTmpContainerRect = new Rect();
    private float mLastWidth;
    private float mLastHeight;
    private float mLastDsDx = 1.0f;
    private float mLastDsDy = 1.0f;
    private float mLastX;
    private float mLastY;
    private boolean mHiddenForCrop = false;

    public SurfaceControlWithBackground(SurfaceControlWithBackground other) {
        super(other);
        this.mBackgroundControl = other.mBackgroundControl;
        this.mVisible = other.mVisible;
        this.mWindowSurfaceController = other.mWindowSurfaceController;
    }

    public SurfaceControlWithBackground(SurfaceSession s, String name, int w, int h, int format, int flags, int windowType, int ownerUid, WindowSurfaceController windowSurfaceController) throws Surface.OutOfResourcesException {
        super(s, name, w, h, format, flags, windowType, ownerUid);
        if (windowType != 1 && windowType != 3 || !windowSurfaceController.mAnimator.mWin.isLetterboxedAppWindow()) {
            return;
        }
        this.mWindowSurfaceController = windowSurfaceController;
        this.mLastWidth = w;
        this.mLastHeight = h;
        this.mWindowSurfaceController.getContainerRect(this.mTmpContainerRect);
        this.mBackgroundControl = new SurfaceControl(s, "Background for - " + name, this.mTmpContainerRect.width(), this.mTmpContainerRect.height(), -1, flags | 0x20000);
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.setAlpha(alpha);
    }

    @Override
    public void setLayer(int zorder) {
        super.setLayer(zorder);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.setLayer(zorder - 1);
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mLastX = x;
        this.mLastY = y;
        this.updateBgPosition();
    }

    private void updateBgPosition() {
        this.mWindowSurfaceController.getContainerRect(this.mTmpContainerRect);
        Rect winFrame = this.mWindowSurfaceController.mAnimator.mWin.mFrame;
        float offsetX = (float)(this.mTmpContainerRect.left - winFrame.left) * this.mLastDsDx;
        float offsetY = (float)(this.mTmpContainerRect.top - winFrame.top) * this.mLastDsDy;
        this.mBackgroundControl.setPosition(this.mLastX + offsetX, this.mLastY + offsetY);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mLastWidth = w;
        this.mLastHeight = h;
        this.mWindowSurfaceController.getContainerRect(this.mTmpContainerRect);
        this.mBackgroundControl.setSize(this.mTmpContainerRect.width(), this.mTmpContainerRect.height());
    }

    @Override
    public void setWindowCrop(Rect crop) {
        super.setWindowCrop(crop);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.calculateBgCrop(crop);
        this.mBackgroundControl.setWindowCrop(this.mTmpContainerRect);
        this.mHiddenForCrop = this.mTmpContainerRect.isEmpty();
        this.updateBackgroundVisibility();
    }

    @Override
    public void setFinalCrop(Rect crop) {
        super.setFinalCrop(crop);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mWindowSurfaceController.getContainerRect(this.mTmpContainerRect);
        this.mBackgroundControl.setFinalCrop(this.mTmpContainerRect);
    }

    private void calculateBgCrop(Rect crop) {
        float d;
        Rect contentInsets = this.mWindowSurfaceController.mAnimator.mWin.mContentInsets;
        float f = d = contentInsets.top == 0 ? 0.0f : (float)crop.top / (float)contentInsets.top;
        if (d > 1.0f) {
            this.mTmpContainerRect.setEmpty();
            return;
        }
        d = d < 0.025f ? 0.0f : d;
        this.mWindowSurfaceController.getContainerRect(this.mTmpContainerRect);
        int backgroundWidth = 0;
        int backgroundHeight = 0;
        Rect winFrame = this.mWindowSurfaceController.mAnimator.mWin.mFrame;
        int offsetX = (int)((float)(winFrame.left - this.mTmpContainerRect.left) * this.mLastDsDx);
        int offsetY = (int)((float)(winFrame.top - this.mTmpContainerRect.top) * this.mLastDsDy);
        int bgPosition = this.mWindowSurfaceController.mAnimator.mService.getNavBarPosition();
        switch (bgPosition) {
            case 1: {
                backgroundWidth = (int)((double)(((float)this.mTmpContainerRect.width() - this.mLastWidth) * (1.0f - d)) + 0.5);
                backgroundHeight = crop.height();
                offsetX += crop.left - backgroundWidth;
                offsetY += crop.top;
                break;
            }
            case 2: {
                backgroundWidth = (int)((double)(((float)this.mTmpContainerRect.width() - this.mLastWidth) * (1.0f - d)) + 0.5);
                backgroundHeight = crop.height();
                offsetX += crop.right;
                offsetY += crop.top;
                break;
            }
            case 4: {
                backgroundWidth = crop.width();
                backgroundHeight = (int)((double)(((float)this.mTmpContainerRect.height() - this.mLastHeight) * (1.0f - d)) + 0.5);
                offsetX += crop.left;
                offsetY += crop.bottom;
            }
        }
        this.mTmpContainerRect.set(offsetX, offsetY, offsetX + backgroundWidth, offsetY + backgroundHeight);
    }

    @Override
    public void setLayerStack(int layerStack) {
        super.setLayerStack(layerStack);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.setLayerStack(layerStack);
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.updateBackgroundVisibility();
    }

    @Override
    public void setSecure(boolean isSecure) {
        super.setSecure(isSecure);
    }

    @Override
    public void setMatrix(float dsdx, float dtdx, float dtdy, float dsdy) {
        super.setMatrix(dsdx, dtdx, dtdy, dsdy);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.setMatrix(dsdx, dtdx, dtdy, dsdy);
        this.mLastDsDx = dsdx;
        this.mLastDsDy = dsdy;
        this.updateBgPosition();
    }

    @Override
    public void hide() {
        super.hide();
        this.mVisible = false;
        this.updateBackgroundVisibility();
    }

    @Override
    public void show() {
        super.show();
        this.mVisible = true;
        this.updateBackgroundVisibility();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.destroy();
    }

    @Override
    public void release() {
        super.release();
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.release();
    }

    @Override
    public void setTransparentRegionHint(Region region) {
        super.setTransparentRegionHint(region);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.setTransparentRegionHint(region);
    }

    @Override
    public void deferTransactionUntil(IBinder handle, long frame) {
        super.deferTransactionUntil(handle, frame);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.deferTransactionUntil(handle, frame);
    }

    @Override
    public void deferTransactionUntil(Surface barrier, long frame) {
        super.deferTransactionUntil(barrier, frame);
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundControl.deferTransactionUntil(barrier, frame);
    }

    private void updateBackgroundVisibility() {
        if (this.mBackgroundControl == null) {
            return;
        }
        AppWindowToken appWindowToken = this.mWindowSurfaceController.mAnimator.mWin.mAppToken;
        if (!this.mHiddenForCrop && this.mVisible && appWindowToken != null && appWindowToken.fillsParent()) {
            this.mBackgroundControl.show();
        } else {
            this.mBackgroundControl.hide();
        }
    }
}

