/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class UsbHIDDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbHIDDescriptor";
    private int mRelease;
    private byte mCountryCode;
    private byte mNumDescriptors;
    private byte mDescriptorType;
    private int mDescriptorLen;

    public UsbHIDDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 3;
    }

    public int getRelease() {
        return this.mRelease;
    }

    public byte getCountryCode() {
        return this.mCountryCode;
    }

    public byte getNumDescriptors() {
        return this.mNumDescriptors;
    }

    public byte getDescriptorType() {
        return this.mDescriptorType;
    }

    public int getDescriptorLen() {
        return this.mDescriptorLen;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mRelease = stream.unpackUsbShort();
        this.mCountryCode = stream.getByte();
        this.mNumDescriptors = stream.getByte();
        this.mDescriptorType = stream.getByte();
        this.mDescriptorLen = stream.unpackUsbShort();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Spec: " + ReportCanvas.getBCDString(this.getRelease()));
        canvas.writeListItem("Type: " + ReportCanvas.getBCDString(this.getDescriptorType()));
        canvas.writeListItem("" + this.getNumDescriptors() + " Descriptors Len: " + this.getDescriptorLen());
        canvas.closeList();
    }
}

