/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.util.Log;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACEndpoint;
import com.android.server.usb.descriptors.UsbACInterface;
import com.android.server.usb.descriptors.UsbACTerminal;
import com.android.server.usb.descriptors.UsbConfigDescriptor;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDeviceDescriptor;
import com.android.server.usb.descriptors.UsbEndpointDescriptor;
import com.android.server.usb.descriptors.UsbHIDDescriptor;
import com.android.server.usb.descriptors.UsbInterfaceAssoc;
import com.android.server.usb.descriptors.UsbInterfaceDescriptor;
import com.android.server.usb.descriptors.UsbUnknown;
import java.util.ArrayList;

public final class UsbDescriptorParser {
    private static final String TAG = "UsbDescriptorParser";
    private ArrayList<UsbDescriptor> mDescriptors = new ArrayList();
    private UsbDeviceDescriptor mDeviceDescriptor;
    private UsbInterfaceDescriptor mCurInterfaceDescriptor;
    private int mACInterfacesSpec = 256;
    private static final float IN_HEADSET_TRIGGER = 0.75f;
    private static final float OUT_HEADSET_TRIGGER = 0.75f;

    public int getUsbSpec() {
        if (this.mDeviceDescriptor != null) {
            return this.mDeviceDescriptor.getSpec();
        }
        throw new IllegalArgumentException();
    }

    public void setACInterfaceSpec(int spec) {
        this.mACInterfacesSpec = spec;
    }

    public int getACInterfaceSpec() {
        return this.mACInterfacesSpec;
    }

    private UsbDescriptor allocDescriptor(ByteStream stream) {
        stream.resetReadCount();
        int length = stream.getUnsignedByte();
        byte type = stream.getByte();
        UsbDescriptor descriptor = null;
        switch (type) {
            case 1: {
                this.mDeviceDescriptor = new UsbDeviceDescriptor(length, type);
                descriptor = this.mDeviceDescriptor;
                break;
            }
            case 2: {
                descriptor = new UsbConfigDescriptor(length, type);
                break;
            }
            case 4: {
                this.mCurInterfaceDescriptor = new UsbInterfaceDescriptor(length, type);
                descriptor = this.mCurInterfaceDescriptor;
                break;
            }
            case 5: {
                descriptor = new UsbEndpointDescriptor(length, type);
                break;
            }
            case 33: {
                descriptor = new UsbHIDDescriptor(length, type);
                break;
            }
            case 11: {
                descriptor = new UsbInterfaceAssoc(length, type);
                break;
            }
            case 36: {
                descriptor = UsbACInterface.allocDescriptor(this, stream, length, type);
                break;
            }
            case 37: {
                descriptor = UsbACEndpoint.allocDescriptor(this, length, type);
                break;
            }
        }
        if (descriptor == null) {
            Log.i(TAG, "Unknown Descriptor len: " + length + " type:0x" + Integer.toHexString(type));
            descriptor = new UsbUnknown(length, type);
        }
        return descriptor;
    }

    public UsbDeviceDescriptor getDeviceDescriptor() {
        return this.mDeviceDescriptor;
    }

    public UsbInterfaceDescriptor getCurInterface() {
        return this.mCurInterfaceDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDescriptors(byte[] descriptors) {
        this.mDescriptors.clear();
        ByteStream stream = new ByteStream(descriptors);
        while (stream.available() > 0) {
            UsbDescriptor descriptor = null;
            try {
                descriptor = this.allocDescriptor(stream);
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception allocating USB descriptor.", ex);
            }
            if (descriptor == null) continue;
            try {
                descriptor.parseRawDescriptors(stream);
                descriptor.postParse(stream);
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception parsing USB descriptors.", ex);
                descriptor.setStatus(4);
            }
            finally {
                this.mDescriptors.add(descriptor);
            }
        }
    }

    public boolean parseDevice(String deviceAddr) {
        byte[] rawDescriptors = this.getRawDescriptors(deviceAddr);
        if (rawDescriptors != null) {
            this.parseDescriptors(rawDescriptors);
            return true;
        }
        return false;
    }

    private native byte[] getRawDescriptors(String var1);

    public int getParsingSpec() {
        return this.mDeviceDescriptor != null ? this.mDeviceDescriptor.getSpec() : 0;
    }

    public ArrayList<UsbDescriptor> getDescriptors() {
        return this.mDescriptors;
    }

    public ArrayList<UsbDescriptor> getDescriptors(byte type) {
        ArrayList<UsbDescriptor> list = new ArrayList<UsbDescriptor>();
        for (UsbDescriptor descriptor : this.mDescriptors) {
            if (descriptor.getType() != type) continue;
            list.add(descriptor);
        }
        return list;
    }

    public ArrayList<UsbDescriptor> getInterfaceDescriptorsForClass(byte usbClass) {
        ArrayList<UsbDescriptor> list = new ArrayList<UsbDescriptor>();
        for (UsbDescriptor descriptor : this.mDescriptors) {
            if (descriptor.getType() != 4) continue;
            if (descriptor instanceof UsbInterfaceDescriptor) {
                UsbInterfaceDescriptor intrDesc = (UsbInterfaceDescriptor)descriptor;
                if (intrDesc.getUsbClass() != usbClass) continue;
                list.add(descriptor);
                continue;
            }
            Log.w(TAG, "Unrecognized Interface l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        return list;
    }

    public ArrayList<UsbDescriptor> getACInterfaceDescriptors(byte subtype, byte subclass) {
        ArrayList<UsbDescriptor> list = new ArrayList<UsbDescriptor>();
        for (UsbDescriptor descriptor : this.mDescriptors) {
            if (descriptor.getType() != 36) continue;
            if (descriptor instanceof UsbACInterface) {
                UsbACInterface acDescriptor = (UsbACInterface)descriptor;
                if (acDescriptor.getSubtype() != subtype || acDescriptor.getSubclass() != subclass) continue;
                list.add(descriptor);
                continue;
            }
            Log.w(TAG, "Unrecognized Audio Interface l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        return list;
    }

    public boolean hasHIDDescriptor() {
        ArrayList<UsbDescriptor> descriptors = this.getInterfaceDescriptorsForClass((byte)3);
        return !descriptors.isEmpty();
    }

    public boolean hasMIDIInterface() {
        ArrayList<UsbDescriptor> descriptors = this.getInterfaceDescriptorsForClass((byte)1);
        for (UsbDescriptor descriptor : descriptors) {
            if (descriptor instanceof UsbInterfaceDescriptor) {
                UsbInterfaceDescriptor interfaceDescr = (UsbInterfaceDescriptor)descriptor;
                if (interfaceDescr.getUsbSubclass() != 3) continue;
                return true;
            }
            Log.w(TAG, "Undefined Audio Class Interface l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        return false;
    }

    public float getInputHeadsetProbability() {
        if (this.hasMIDIInterface()) {
            return 0.0f;
        }
        float probability = 0.0f;
        boolean hasMic = false;
        ArrayList<UsbDescriptor> acDescriptors = this.getACInterfaceDescriptors((byte)2, (byte)1);
        for (UsbDescriptor descriptor : acDescriptors) {
            if (descriptor instanceof UsbACTerminal) {
                UsbACTerminal inDescr = (UsbACTerminal)descriptor;
                if (inDescr.getTerminalType() != 513 && inDescr.getTerminalType() != 1026 && inDescr.getTerminalType() != 1024 && inDescr.getTerminalType() != 1539) continue;
                hasMic = true;
                break;
            }
            Log.w(TAG, "Undefined Audio Input terminal l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        boolean hasSpeaker = false;
        acDescriptors = this.getACInterfaceDescriptors((byte)3, (byte)1);
        for (UsbDescriptor descriptor : acDescriptors) {
            if (descriptor instanceof UsbACTerminal) {
                UsbACTerminal outDescr = (UsbACTerminal)descriptor;
                if (outDescr.getTerminalType() != 769 && outDescr.getTerminalType() != 770 && outDescr.getTerminalType() != 1026) continue;
                hasSpeaker = true;
                break;
            }
            Log.w(TAG, "Undefined Audio Output terminal l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        if (hasMic && hasSpeaker) {
            probability += 0.75f;
        }
        if (hasMic && this.hasHIDDescriptor()) {
            probability += 0.25f;
        }
        return probability;
    }

    public boolean isInputHeadset() {
        Log.i(TAG, "---- isInputHeadset() prob:" + this.getInputHeadsetProbability() * 100.0f + "%");
        return this.getInputHeadsetProbability() >= 0.75f;
    }

    public float getOutputHeadsetProbability() {
        if (this.hasMIDIInterface()) {
            return 0.0f;
        }
        float probability = 0.0f;
        boolean hasSpeaker = false;
        ArrayList<UsbDescriptor> acDescriptors = this.getACInterfaceDescriptors((byte)3, (byte)1);
        for (UsbDescriptor descriptor : acDescriptors) {
            if (descriptor instanceof UsbACTerminal) {
                UsbACTerminal outDescr = (UsbACTerminal)descriptor;
                if (outDescr.getTerminalType() != 769 && outDescr.getTerminalType() != 770 && outDescr.getTerminalType() != 1026) continue;
                hasSpeaker = true;
                break;
            }
            Log.w(TAG, "Undefined Audio Output terminal l: " + descriptor.getLength() + " t:0x" + Integer.toHexString(descriptor.getType()));
        }
        if (hasSpeaker) {
            probability += 0.75f;
        }
        if (hasSpeaker && this.hasHIDDescriptor()) {
            probability += 0.25f;
        }
        return probability;
    }

    public boolean isOutputHeadset() {
        Log.i(TAG, "---- isOutputHeadset() prob:" + this.getOutputHeadsetProbability() * 100.0f + "%");
        return this.getOutputHeadsetProbability() >= 0.75f;
    }
}

