/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACEndpoint;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class UsbACMidiEndpoint
extends UsbACEndpoint {
    private static final String TAG = "UsbACMidiEndpoint";
    private byte mNumJacks;
    private byte[] mJackIds;

    public UsbACMidiEndpoint(int length, byte type, byte subclass) {
        super(length, type, subclass);
    }

    public byte getNumJacks() {
        return this.mNumJacks;
    }

    public byte[] getJackIds() {
        return this.mJackIds;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        super.parseRawDescriptors(stream);
        this.mNumJacks = stream.getByte();
        this.mJackIds = new byte[this.mNumJacks];
        for (int jack = 0; jack < this.mNumJacks; ++jack) {
            this.mJackIds[jack] = stream.getByte();
        }
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.writeHeader(3, "AC Midi Endpoint: " + ReportCanvas.getHexString(this.getType()) + " Length: " + this.getLength());
        canvas.openList();
        canvas.writeListItem("" + this.getNumJacks() + " Jacks.");
        canvas.closeList();
    }
}

