/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACInterface;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class Usb20ASGeneral
extends UsbACInterface {
    private static final String TAG = "Usb20ASGeneral";
    private byte mTerminalLink;
    private byte mControls;
    private byte mFormatType;
    private int mFormats;
    private byte mNumChannels;
    private int mChannelConfig;
    private byte mChannelNames;

    public Usb20ASGeneral(int length, byte type, byte subtype, byte subclass) {
        super(length, type, subtype, subclass);
    }

    public byte getTerminalLink() {
        return this.mTerminalLink;
    }

    public byte getControls() {
        return this.mControls;
    }

    public byte getFormatType() {
        return this.mFormatType;
    }

    public int getFormats() {
        return this.mFormats;
    }

    public byte getNumChannels() {
        return this.mNumChannels;
    }

    public int getChannelConfig() {
        return this.mChannelConfig;
    }

    public byte getChannelNames() {
        return this.mChannelNames;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mTerminalLink = stream.getByte();
        this.mControls = stream.getByte();
        this.mFormatType = stream.getByte();
        this.mFormats = stream.unpackUsbInt();
        this.mNumChannels = stream.getByte();
        this.mChannelConfig = stream.unpackUsbInt();
        this.mChannelNames = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Terminal Link: " + this.getTerminalLink());
        canvas.writeListItem("Controls: " + ReportCanvas.getHexString(this.getControls()));
        canvas.writeListItem("Format Type: " + ReportCanvas.getHexString(this.getFormatType()));
        canvas.writeListItem("Formats: " + ReportCanvas.getHexString(this.getFormats()));
        canvas.writeListItem("Num Channels: " + this.getNumChannels());
        canvas.writeListItem("Channel Config: " + ReportCanvas.getHexString(this.getChannelConfig()));
        canvas.writeListItem("Channel Names String ID: " + this.getChannelNames());
        canvas.closeList();
    }
}

