/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.server.tv.TvRemoteProviderProxy;
import java.util.ArrayList;
import java.util.Collections;

final class TvRemoteProviderWatcher {
    private static final String TAG = "TvRemoteProvWatcher";
    private static final boolean DEBUG = Log.isLoggable("TvRemoteProvWatcher", 2);
    private final Context mContext;
    private final ProviderMethods mProvider;
    private final Handler mHandler;
    private final PackageManager mPackageManager;
    private final ArrayList<TvRemoteProviderProxy> mProviderProxies = new ArrayList();
    private final int mUserId;
    private final String mUnbundledServicePackage;
    private boolean mRunning;
    private final BroadcastReceiver mScanPackagesReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (DEBUG) {
                Slog.d(TvRemoteProviderWatcher.TAG, "Received package manager broadcast: " + intent);
            }
            TvRemoteProviderWatcher.this.mHandler.post(TvRemoteProviderWatcher.this.mScanPackagesRunnable);
        }
    };
    private final Runnable mScanPackagesRunnable = new Runnable(){

        @Override
        public void run() {
            TvRemoteProviderWatcher.this.scanPackages();
        }
    };

    public TvRemoteProviderWatcher(Context context, ProviderMethods provider, Handler handler) {
        this.mContext = context;
        this.mProvider = provider;
        this.mHandler = handler;
        this.mUserId = UserHandle.myUserId();
        this.mPackageManager = context.getPackageManager();
        this.mUnbundledServicePackage = context.getString(17039688);
    }

    public void start() {
        if (DEBUG) {
            Slog.d(TAG, "start()");
        }
        if (!this.mRunning) {
            this.mRunning = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_CHANGED");
            filter.addAction("android.intent.action.PACKAGE_REPLACED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addDataScheme("package");
            this.mContext.registerReceiverAsUser(this.mScanPackagesReceiver, new UserHandle(this.mUserId), filter, null, this.mHandler);
            this.mHandler.post(this.mScanPackagesRunnable);
        }
    }

    public void stop() {
        if (this.mRunning) {
            this.mRunning = false;
            this.mContext.unregisterReceiver(this.mScanPackagesReceiver);
            this.mHandler.removeCallbacks(this.mScanPackagesRunnable);
            for (int i = this.mProviderProxies.size() - 1; i >= 0; --i) {
                this.mProviderProxies.get(i).stop();
            }
        }
    }

    private void scanPackages() {
        if (!this.mRunning) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "scanPackages()");
        }
        int targetIndex = 0;
        Intent intent = new Intent("com.android.media.tv.remoteprovider.TvRemoteProvider");
        for (ResolveInfo resolveInfo : this.mPackageManager.queryIntentServicesAsUser(intent, 0, this.mUserId)) {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !this.verifyServiceTrusted(serviceInfo)) continue;
            int sourceIndex = this.findProvider(serviceInfo.packageName, serviceInfo.name);
            if (sourceIndex < 0) {
                TvRemoteProviderProxy providerProxy = new TvRemoteProviderProxy(this.mContext, new ComponentName(serviceInfo.packageName, serviceInfo.name), this.mUserId, serviceInfo.applicationInfo.uid);
                providerProxy.start();
                this.mProviderProxies.add(targetIndex++, providerProxy);
                this.mProvider.addProvider(providerProxy);
                continue;
            }
            if (sourceIndex < targetIndex) continue;
            TvRemoteProviderProxy provider = this.mProviderProxies.get(sourceIndex);
            provider.start();
            provider.rebindIfDisconnected();
            Collections.swap(this.mProviderProxies, sourceIndex, targetIndex++);
        }
        if (DEBUG) {
            Log.d(TAG, "scanPackages() targetIndex " + targetIndex);
        }
        if (targetIndex < this.mProviderProxies.size()) {
            for (int i = this.mProviderProxies.size() - 1; i >= targetIndex; --i) {
                TvRemoteProviderProxy providerProxy = this.mProviderProxies.get(i);
                this.mProvider.removeProvider(providerProxy);
                this.mProviderProxies.remove(providerProxy);
                providerProxy.stop();
            }
        }
    }

    private boolean verifyServiceTrusted(ServiceInfo serviceInfo) {
        if (serviceInfo.permission == null || !serviceInfo.permission.equals("android.permission.BIND_TV_REMOTE_SERVICE")) {
            Slog.w(TAG, "Ignoring atv remote provider service because it did not require the BIND_TV_REMOTE_SERVICE permission in its manifest: " + serviceInfo.packageName + "/" + serviceInfo.name);
            return false;
        }
        if (!serviceInfo.packageName.equals(this.mUnbundledServicePackage)) {
            Slog.w(TAG, "Ignoring atv remote provider service because the package has not been set and/or whitelisted: " + serviceInfo.packageName + "/" + serviceInfo.name);
            return false;
        }
        if (!this.hasNecessaryPermissions(serviceInfo.packageName)) {
            Slog.w(TAG, "Ignoring atv remote provider service because its package does not have TV_VIRTUAL_REMOTE_CONTROLLER permission: " + serviceInfo.packageName);
            return false;
        }
        return true;
    }

    private boolean hasNecessaryPermissions(String packageName) {
        return this.mPackageManager.checkPermission("android.permission.TV_VIRTUAL_REMOTE_CONTROLLER", packageName) == 0;
    }

    private int findProvider(String packageName, String className) {
        int count = this.mProviderProxies.size();
        for (int i = 0; i < count; ++i) {
            TvRemoteProviderProxy provider = this.mProviderProxies.get(i);
            if (!provider.hasComponentName(packageName, className)) continue;
            return i;
        }
        return -1;
    }

    public static interface ProviderMethods {
        public void addProvider(TvRemoteProviderProxy var1);

        public void removeProvider(TvRemoteProviderProxy var1);
    }
}

