/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.soundtrigger;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.app.ISoundTriggerService;
import com.android.server.SystemService;
import com.android.server.soundtrigger.SoundTriggerDbHelper;
import com.android.server.soundtrigger.SoundTriggerHelper;
import com.android.server.soundtrigger.SoundTriggerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.TreeMap;
import java.util.UUID;

public class SoundTriggerService
extends SystemService {
    private static final String TAG = "SoundTriggerService";
    private static final boolean DEBUG = true;
    final Context mContext;
    private Object mLock;
    private final SoundTriggerServiceStub mServiceStub;
    private final LocalSoundTriggerService mLocalSoundTriggerService;
    private SoundTriggerDbHelper mDbHelper;
    private SoundTriggerHelper mSoundTriggerHelper;
    private final TreeMap<UUID, SoundTrigger.SoundModel> mLoadedModels;
    private final TreeMap<UUID, LocalSoundTriggerRecognitionStatusCallback> mIntentCallbacks;
    private PowerManager.WakeLock mWakelock;
    private PendingIntent.OnFinished mCallbackCompletedHandler = new PendingIntent.OnFinished(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTriggerService.this.mWakelock.release();
            }
        }
    };

    public SoundTriggerService(Context context) {
        super(context);
        this.mContext = context;
        this.mServiceStub = new SoundTriggerServiceStub();
        this.mLocalSoundTriggerService = new LocalSoundTriggerService(context);
        this.mLoadedModels = new TreeMap();
        this.mIntentCallbacks = new TreeMap();
        this.mLock = new Object();
    }

    @Override
    public void onStart() {
        this.publishBinderService("soundtrigger", this.mServiceStub);
        this.publishLocalService(SoundTriggerInternal.class, this.mLocalSoundTriggerService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            this.initSoundTriggerHelper();
            this.mLocalSoundTriggerService.setSoundTriggerHelper(this.mSoundTriggerHelper);
        } else if (600 == phase) {
            this.mDbHelper = new SoundTriggerDbHelper(this.mContext);
        }
    }

    @Override
    public void onStartUser(int userHandle) {
    }

    @Override
    public void onSwitchUser(int userHandle) {
    }

    private synchronized void initSoundTriggerHelper() {
        if (this.mSoundTriggerHelper == null) {
            this.mSoundTriggerHelper = new SoundTriggerHelper(this.mContext);
        }
    }

    private synchronized boolean isInitialized() {
        if (this.mSoundTriggerHelper == null) {
            Slog.e(TAG, "SoundTriggerHelper not initialized.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabWakeLock() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWakelock == null) {
                PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
                this.mWakelock = pm.newWakeLock(1, TAG);
            }
            this.mWakelock.acquire();
        }
    }

    private void enforceCallingPermission(String permission2) {
        if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
            throw new SecurityException("Caller does not hold the permission " + permission2);
        }
    }

    public final class LocalSoundTriggerService
    extends SoundTriggerInternal {
        private final Context mContext;
        private SoundTriggerHelper mSoundTriggerHelper;

        LocalSoundTriggerService(Context context) {
            this.mContext = context;
        }

        synchronized void setSoundTriggerHelper(SoundTriggerHelper helper) {
            this.mSoundTriggerHelper = helper;
        }

        @Override
        public int startRecognition(int keyphraseId, SoundTrigger.KeyphraseSoundModel soundModel, IRecognitionStatusCallback listener, SoundTrigger.RecognitionConfig recognitionConfig) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.startKeyphraseRecognition(keyphraseId, soundModel, listener, recognitionConfig);
        }

        @Override
        public synchronized int stopRecognition(int keyphraseId, IRecognitionStatusCallback listener) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.stopKeyphraseRecognition(keyphraseId, listener);
        }

        @Override
        public SoundTrigger.ModuleProperties getModuleProperties() {
            if (!this.isInitialized()) {
                return null;
            }
            return this.mSoundTriggerHelper.getModuleProperties();
        }

        @Override
        public int unloadKeyphraseModel(int keyphraseId) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.unloadKeyphraseSoundModel(keyphraseId);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!this.isInitialized()) {
                return;
            }
            this.mSoundTriggerHelper.dump(fd, pw, args);
        }

        private synchronized boolean isInitialized() {
            if (this.mSoundTriggerHelper == null) {
                Slog.e(SoundTriggerService.TAG, "SoundTriggerHelper not initialized.");
                return false;
            }
            return true;
        }
    }

    private final class LocalSoundTriggerRecognitionStatusCallback
    extends IRecognitionStatusCallback.Stub {
        private UUID mUuid;
        private PendingIntent mCallbackIntent;
        private SoundTrigger.RecognitionConfig mRecognitionConfig;

        public LocalSoundTriggerRecognitionStatusCallback(UUID modelUuid, PendingIntent callbackIntent, SoundTrigger.RecognitionConfig config) {
            this.mUuid = modelUuid;
            this.mCallbackIntent = callbackIntent;
            this.mRecognitionConfig = config;
        }

        @Override
        public boolean pingBinder() {
            return this.mCallbackIntent != null;
        }

        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent event) {
            if (this.mCallbackIntent == null) {
                return;
            }
            SoundTriggerService.this.grabWakeLock();
            Slog.w(SoundTriggerService.TAG, "Keyphrase sound trigger event: " + event);
            Intent extras = new Intent();
            extras.putExtra("android.media.soundtrigger.MESSAGE_TYPE", 0);
            extras.putExtra("android.media.soundtrigger.RECOGNITION_EVENT", event);
            try {
                this.mCallbackIntent.send(SoundTriggerService.this.mContext, 0, extras, SoundTriggerService.this.mCallbackCompletedHandler, null);
                if (!this.mRecognitionConfig.allowMultipleTriggers) {
                    this.removeCallback(false);
                }
            }
            catch (PendingIntent.CanceledException e) {
                this.removeCallback(true);
            }
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent event) {
            if (this.mCallbackIntent == null) {
                return;
            }
            SoundTriggerService.this.grabWakeLock();
            Slog.w(SoundTriggerService.TAG, "Generic sound trigger event: " + event);
            Intent extras = new Intent();
            extras.putExtra("android.media.soundtrigger.MESSAGE_TYPE", 0);
            extras.putExtra("android.media.soundtrigger.RECOGNITION_EVENT", event);
            try {
                this.mCallbackIntent.send(SoundTriggerService.this.mContext, 0, extras, SoundTriggerService.this.mCallbackCompletedHandler, null);
                if (!this.mRecognitionConfig.allowMultipleTriggers) {
                    this.removeCallback(false);
                }
            }
            catch (PendingIntent.CanceledException e) {
                this.removeCallback(true);
            }
        }

        @Override
        public void onError(int status) {
            if (this.mCallbackIntent == null) {
                return;
            }
            SoundTriggerService.this.grabWakeLock();
            Slog.i(SoundTriggerService.TAG, "onError: " + status);
            Intent extras = new Intent();
            extras.putExtra("android.media.soundtrigger.MESSAGE_TYPE", 1);
            extras.putExtra("android.media.soundtrigger.STATUS", status);
            try {
                this.mCallbackIntent.send(SoundTriggerService.this.mContext, 0, extras, SoundTriggerService.this.mCallbackCompletedHandler, null);
                this.removeCallback(false);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeCallback(true);
            }
        }

        @Override
        public void onRecognitionPaused() {
            if (this.mCallbackIntent == null) {
                return;
            }
            SoundTriggerService.this.grabWakeLock();
            Slog.i(SoundTriggerService.TAG, "onRecognitionPaused");
            Intent extras = new Intent();
            extras.putExtra("android.media.soundtrigger.MESSAGE_TYPE", 2);
            try {
                this.mCallbackIntent.send(SoundTriggerService.this.mContext, 0, extras, SoundTriggerService.this.mCallbackCompletedHandler, null);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeCallback(true);
            }
        }

        @Override
        public void onRecognitionResumed() {
            if (this.mCallbackIntent == null) {
                return;
            }
            SoundTriggerService.this.grabWakeLock();
            Slog.i(SoundTriggerService.TAG, "onRecognitionResumed");
            Intent extras = new Intent();
            extras.putExtra("android.media.soundtrigger.MESSAGE_TYPE", 3);
            try {
                this.mCallbackIntent.send(SoundTriggerService.this.mContext, 0, extras, SoundTriggerService.this.mCallbackCompletedHandler, null);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeCallback(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCallback(boolean releaseWakeLock) {
            this.mCallbackIntent = null;
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTriggerService.this.mIntentCallbacks.remove(this.mUuid);
                if (releaseWakeLock) {
                    SoundTriggerService.this.mWakelock.release();
                }
            }
        }
    }

    class SoundTriggerServiceStub
    extends ISoundTriggerService.Stub {
        SoundTriggerServiceStub() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf(SoundTriggerService.TAG, "SoundTriggerService Crash", e);
                }
                throw e;
            }
        }

        @Override
        public int startRecognition(ParcelUuid parcelUuid, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig config) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "startRecognition(): Uuid : " + parcelUuid);
            SoundTrigger.GenericSoundModel model = this.getSoundModel(parcelUuid);
            if (model == null) {
                Slog.e(SoundTriggerService.TAG, "Null model in database for id: " + parcelUuid);
                return Integer.MIN_VALUE;
            }
            return SoundTriggerService.this.mSoundTriggerHelper.startGenericRecognition(parcelUuid.getUuid(), model, callback, config);
        }

        @Override
        public int stopRecognition(ParcelUuid parcelUuid, IRecognitionStatusCallback callback) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "stopRecognition(): Uuid : " + parcelUuid);
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return SoundTriggerService.this.mSoundTriggerHelper.stopGenericRecognition(parcelUuid.getUuid(), callback);
        }

        @Override
        public SoundTrigger.GenericSoundModel getSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "getSoundModel(): id = " + soundModelId);
            SoundTrigger.GenericSoundModel model = SoundTriggerService.this.mDbHelper.getGenericSoundModel(soundModelId.getUuid());
            return model;
        }

        @Override
        public void updateSoundModel(SoundTrigger.GenericSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "updateSoundModel(): model = " + soundModel);
            SoundTriggerService.this.mDbHelper.updateGenericSoundModel(soundModel);
        }

        @Override
        public void deleteSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "deleteSoundModel(): id = " + soundModelId);
            SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModelId.getUuid());
            SoundTriggerService.this.mDbHelper.deleteGenericSoundModel(soundModelId.getUuid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int loadGenericSoundModel(SoundTrigger.GenericSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            if (soundModel == null || soundModel.uuid == null) {
                Slog.e(SoundTriggerService.TAG, "Invalid sound model");
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "loadGenericSoundModel(): id = " + soundModel.uuid);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTrigger.SoundModel oldModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModel.uuid);
                if (oldModel != null && !oldModel.equals(soundModel)) {
                    SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModel.uuid);
                    SoundTriggerService.this.mIntentCallbacks.remove(soundModel.uuid);
                }
                SoundTriggerService.this.mLoadedModels.put(soundModel.uuid, soundModel);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int loadKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            if (soundModel == null || soundModel.uuid == null) {
                Slog.e(SoundTriggerService.TAG, "Invalid sound model");
                return Integer.MIN_VALUE;
            }
            if (soundModel.keyphrases == null || soundModel.keyphrases.length != 1) {
                Slog.e(SoundTriggerService.TAG, "Only one keyphrase per model is currently supported.");
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "loadKeyphraseSoundModel(): id = " + soundModel.uuid);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTrigger.SoundModel oldModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModel.uuid);
                if (oldModel != null && !oldModel.equals(soundModel)) {
                    SoundTriggerService.this.mSoundTriggerHelper.unloadKeyphraseSoundModel(soundModel.keyphrases[0].id);
                    SoundTriggerService.this.mIntentCallbacks.remove(soundModel.uuid);
                }
                SoundTriggerService.this.mLoadedModels.put(soundModel.uuid, soundModel);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startRecognitionForIntent(ParcelUuid soundModelId, PendingIntent callbackIntent, SoundTrigger.RecognitionConfig config) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "startRecognition(): id = " + soundModelId);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    return Integer.MIN_VALUE;
                }
                LocalSoundTriggerRecognitionStatusCallback callback = (LocalSoundTriggerRecognitionStatusCallback)SoundTriggerService.this.mIntentCallbacks.get(soundModelId.getUuid());
                if (callback != null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is already running");
                    return Integer.MIN_VALUE;
                }
                callback = new LocalSoundTriggerRecognitionStatusCallback(soundModelId.getUuid(), callbackIntent, config);
                switch (soundModel.type) {
                    case 0: {
                        SoundTrigger.KeyphraseSoundModel keyphraseSoundModel = (SoundTrigger.KeyphraseSoundModel)soundModel;
                        ret = SoundTriggerService.this.mSoundTriggerHelper.startKeyphraseRecognition(keyphraseSoundModel.keyphrases[0].id, keyphraseSoundModel, callback, config);
                        break;
                    }
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.startGenericRecognition(soundModel.uuid, (SoundTrigger.GenericSoundModel)soundModel, callback, config);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to start model: " + ret);
                    return ret;
                }
                SoundTriggerService.this.mIntentCallbacks.put(soundModelId.getUuid(), callback);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int stopRecognitionForIntent(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "stopRecognition(): id = " + soundModelId);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    return Integer.MIN_VALUE;
                }
                LocalSoundTriggerRecognitionStatusCallback callback = (LocalSoundTriggerRecognitionStatusCallback)SoundTriggerService.this.mIntentCallbacks.get(soundModelId.getUuid());
                if (callback == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not running");
                    return Integer.MIN_VALUE;
                }
                switch (soundModel.type) {
                    case 0: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.stopKeyphraseRecognition(((SoundTrigger.KeyphraseSoundModel)soundModel).keyphrases[0].id, callback);
                        break;
                    }
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.stopGenericRecognition(soundModel.uuid, callback);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to stop model: " + ret);
                    return ret;
                }
                SoundTriggerService.this.mIntentCallbacks.remove(soundModelId.getUuid());
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int unloadSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "unloadSoundModel(): id = " + soundModelId);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    return Integer.MIN_VALUE;
                }
                switch (soundModel.type) {
                    case 0: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.unloadKeyphraseSoundModel(((SoundTrigger.KeyphraseSoundModel)soundModel).keyphrases[0].id);
                        break;
                    }
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModel.uuid);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to unload model");
                    return ret;
                }
                SoundTriggerService.this.mLoadedModels.remove(soundModelId.getUuid());
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRecognitionActive(ParcelUuid parcelUuid) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return false;
            }
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                LocalSoundTriggerRecognitionStatusCallback callback = (LocalSoundTriggerRecognitionStatusCallback)SoundTriggerService.this.mIntentCallbacks.get(parcelUuid.getUuid());
                if (callback == null) {
                    return false;
                }
                return SoundTriggerService.this.mSoundTriggerHelper.isRecognitionRequested(parcelUuid.getUuid());
            }
        }
    }
}

